/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.fluentlenium;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.CucumberException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.fluentlenium.adapter.cucumber.FluentTestContainer;
import org.fluentlenium.configuration.FluentConfiguration;

public class FluentObjectFactory
implements ObjectFactory {
    private final Map<Class<?>, Object> instances = new HashMap();
    private Class<?> configClass;

    public void start() {
        if (Objects.nonNull(this.configClass)) {
            FluentTestContainer.setConfigClass(this.configClass);
            FluentTestContainer.FLUENT_TEST.instance();
        } else {
            FluentTestContainer.setConfigClass(null);
            FluentTestContainer.FLUENT_TEST.instance();
        }
    }

    public void stop() {
        FluentTestContainer.FLUENT_TEST.reset();
        this.instances.clear();
    }

    public boolean addClass(Class<?> aClass) {
        if (this.configClass == null) {
            this.configClass = this.checkClassForConfiguration(aClass);
            if (Objects.nonNull(this.configClass)) {
                FluentTestContainer.setConfigClass(this.configClass);
            }
        }
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        try {
            T instance = type.cast(this.instances.get(type));
            if (instance == null) {
                instance = this.cacheNewInstance(type);
            }
            return instance;
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
    }

    private <T> T cacheNewInstance(Class<T> type) {
        try {
            Object instance = FluentTestContainer.FLUENT_TEST.injector().newInstance(type);
            FluentTestContainer.FLUENT_TEST.injector().inject(instance);
            this.instances.put(type, instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
    }

    private Class<?> checkClassForConfiguration(Class<?> cls) {
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && superClass.isAnnotationPresent(FluentConfiguration.class)) {
            return superClass;
        }
        if (cls.isAnnotationPresent(FluentConfiguration.class)) {
            return cls;
        }
        return null;
    }
}

