/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.cucumber;

import java.util.Arrays;
import java.util.Objects;
import org.fluentlenium.adapter.DefaultFluentControlContainer;
import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.cucumber.FluentCucumberSharedMutator;
import org.fluentlenium.adapter.cucumber.FluentCucumberTest;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.inject.ContainerInstantiator;
import org.fluentlenium.core.inject.DefaultContainerInstantiator;
import org.fluentlenium.core.inject.FluentInjector;

public enum FluentTestContainer {
    FLUENT_TEST;

    private ThreadLocal<FluentAdapter> fluentAdapter = new ThreadLocal();
    private ThreadLocal<FluentControlContainer> controlContainer = new ThreadLocal();
    private ThreadLocal<SharedMutator> sharedMutator = new ThreadLocal();
    private ThreadLocal<FluentInjector> injector = new ThreadLocal();
    private static Class<?> configClass;

    public FluentAdapter instance() {
        if (Objects.isNull(this.fluentAdapter.get())) {
            this.controlContainer.set((FluentControlContainer)new DefaultFluentControlContainer());
            this.sharedMutator.set(new FluentCucumberSharedMutator());
            if (Objects.nonNull(configClass)) {
                this.fluentAdapter.set((FluentAdapter)new FluentCucumberTest(this.controlContainer.get(), configClass, this.sharedMutator.get()));
            } else {
                this.fluentAdapter.set((FluentAdapter)new FluentCucumberTest(this.controlContainer.get(), this.sharedMutator.get()));
            }
            this.injector.set(new FluentInjector((FluentControl)this.fluentAdapter.get(), null, new ComponentsManager((FluentControl)this.fluentAdapter.get()), (ContainerInstantiator)new DefaultContainerInstantiator((FluentControl)this.fluentAdapter.get())));
        }
        return this.fluentAdapter.get();
    }

    public void reset() {
        this.sharedMutator.remove();
        this.controlContainer.remove();
        this.injector.remove();
        configClass = null;
        this.fluentAdapter.remove();
    }

    protected FluentControlContainer getControlContainer() {
        if (this.fluentAdapter.get() == null) {
            this.instance();
        }
        return this.controlContainer.get();
    }

    public static void setConfigClass(Class clazz) {
        configClass = clazz;
    }

    protected SharedMutator getSharedMutator() {
        return this.sharedMutator.get();
    }

    public FluentInjector injector() {
        return this.injector.get();
    }

    public void instantiatePages(Object obj) {
        Arrays.stream(obj.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(Page.class)).forEach(field -> {
            try {
                Object instance = this.injector.get().newInstance(field.getType());
                field.setAccessible(true);
                field.set(obj, instance);
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }
}

