package org.flyte.flytekit;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SdkConfig extends SdkConfig {

  private final String project;

  private final String domain;

  private final String version;

  private AutoValue_SdkConfig(
      String project,
      String domain,
      String version) {
    this.project = project;
    this.domain = domain;
    this.version = version;
  }

  @Override
  public String project() {
    return project;
  }

  @Override
  public String domain() {
    return domain;
  }

  @Override
  public String version() {
    return version;
  }

  @Override
  public String toString() {
    return "SdkConfig{"
        + "project=" + project + ", "
        + "domain=" + domain + ", "
        + "version=" + version
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SdkConfig) {
      SdkConfig that = (SdkConfig) o;
      return this.project.equals(that.project())
          && this.domain.equals(that.domain())
          && this.version.equals(that.version());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= domain.hashCode();
    h$ *= 1000003;
    h$ ^= version.hashCode();
    return h$;
  }

  static final class Builder extends SdkConfig.Builder {
    private String project;
    private String domain;
    private String version;
    Builder() {
    }
    @Override
    public SdkConfig.Builder project(String project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public SdkConfig.Builder domain(String domain) {
      if (domain == null) {
        throw new NullPointerException("Null domain");
      }
      this.domain = domain;
      return this;
    }
    @Override
    public SdkConfig.Builder version(String version) {
      if (version == null) {
        throw new NullPointerException("Null version");
      }
      this.version = version;
      return this;
    }
    @Override
    public SdkConfig build() {
      if (this.project == null
          || this.domain == null
          || this.version == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.domain == null) {
          missing.append(" domain");
        }
        if (this.version == null) {
          missing.append(" version");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SdkConfig(
          this.project,
          this.domain,
          this.version);
    }
  }

}
