package org.flyte.flytekit;

import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SdkRemoteTask<InputT, OutputT> extends SdkRemoteTask<InputT, OutputT> {

  @Nullable
  private final String domain;

  private final String project;

  private final String name;

  @Nullable
  private final String version;

  private final SdkType<InputT> inputs;

  private final SdkType<OutputT> outputs;

  private AutoValue_SdkRemoteTask(
      @Nullable String domain,
      String project,
      String name,
      @Nullable String version,
      SdkType<InputT> inputs,
      SdkType<OutputT> outputs) {
    this.domain = domain;
    this.project = project;
    this.name = name;
    this.version = version;
    this.inputs = inputs;
    this.outputs = outputs;
  }

  @Nullable
  @Override
  public String domain() {
    return domain;
  }

  @Override
  public String project() {
    return project;
  }

  @Override
  public String name() {
    return name;
  }

  @Nullable
  @Override
  public String version() {
    return version;
  }

  @Override
  public SdkType<InputT> inputs() {
    return inputs;
  }

  @Override
  public SdkType<OutputT> outputs() {
    return outputs;
  }

  @Override
  public String toString() {
    return "SdkRemoteTask{"
        + "domain=" + domain + ", "
        + "project=" + project + ", "
        + "name=" + name + ", "
        + "version=" + version + ", "
        + "inputs=" + inputs + ", "
        + "outputs=" + outputs
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SdkRemoteTask) {
      SdkRemoteTask<?, ?> that = (SdkRemoteTask<?, ?>) o;
      return (this.domain == null ? that.domain() == null : this.domain.equals(that.domain()))
          && this.project.equals(that.project())
          && this.name.equals(that.name())
          && (this.version == null ? that.version() == null : this.version.equals(that.version()))
          && this.inputs.equals(that.inputs())
          && this.outputs.equals(that.outputs());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (domain == null) ? 0 : domain.hashCode();
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (version == null) ? 0 : version.hashCode();
    h$ *= 1000003;
    h$ ^= inputs.hashCode();
    h$ *= 1000003;
    h$ ^= outputs.hashCode();
    return h$;
  }

  static final class Builder<InputT, OutputT> extends SdkRemoteTask.Builder<InputT, OutputT> {
    private String domain;
    private String project;
    private String name;
    private String version;
    private SdkType<InputT> inputs;
    private SdkType<OutputT> outputs;
    Builder() {
    }
    @Override
    public SdkRemoteTask.Builder<InputT, OutputT> domain(String domain) {
      this.domain = domain;
      return this;
    }
    @Override
    public SdkRemoteTask.Builder<InputT, OutputT> project(String project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public SdkRemoteTask.Builder<InputT, OutputT> name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public SdkRemoteTask.Builder<InputT, OutputT> version(String version) {
      this.version = version;
      return this;
    }
    @Override
    public SdkRemoteTask.Builder<InputT, OutputT> inputs(SdkType<InputT> inputs) {
      if (inputs == null) {
        throw new NullPointerException("Null inputs");
      }
      this.inputs = inputs;
      return this;
    }
    @Override
    public SdkRemoteTask.Builder<InputT, OutputT> outputs(SdkType<OutputT> outputs) {
      if (outputs == null) {
        throw new NullPointerException("Null outputs");
      }
      this.outputs = outputs;
      return this;
    }
    @Override
    public SdkRemoteTask<InputT, OutputT> build() {
      if (this.project == null
          || this.name == null
          || this.inputs == null
          || this.outputs == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.inputs == null) {
          missing.append(" inputs");
        }
        if (this.outputs == null) {
          missing.append(" outputs");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SdkRemoteTask<InputT, OutputT>(
          this.domain,
          this.project,
          this.name,
          this.version,
          this.inputs,
          this.outputs);
    }
  }

}
