package org.flyte.localengine;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.flyte.api.v1.Binding;
import org.flyte.api.v1.RunnableNode;
import org.flyte.api.v1.WorkflowTemplate;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExecutionNode extends ExecutionNode {

  private final String nodeId;

  private final List<String> upstreamNodeIds;

  @Nullable
  private final List<Binding> bindings;

  @Nullable
  private final RunnableNode runnableNode;

  @Nullable
  private final WorkflowTemplate subWorkflow;

  @Nullable
  private final ExecutionBranchNode branchNode;

  private final int attempts;

  private AutoValue_ExecutionNode(
      String nodeId,
      List<String> upstreamNodeIds,
      @Nullable List<Binding> bindings,
      @Nullable RunnableNode runnableNode,
      @Nullable WorkflowTemplate subWorkflow,
      @Nullable ExecutionBranchNode branchNode,
      int attempts) {
    this.nodeId = nodeId;
    this.upstreamNodeIds = upstreamNodeIds;
    this.bindings = bindings;
    this.runnableNode = runnableNode;
    this.subWorkflow = subWorkflow;
    this.branchNode = branchNode;
    this.attempts = attempts;
  }

  @Override
  public String nodeId() {
    return nodeId;
  }

  @Override
  public List<String> upstreamNodeIds() {
    return upstreamNodeIds;
  }

  @Nullable
  @Override
  public List<Binding> bindings() {
    return bindings;
  }

  @Nullable
  @Override
  public RunnableNode runnableNode() {
    return runnableNode;
  }

  @Nullable
  @Override
  public WorkflowTemplate subWorkflow() {
    return subWorkflow;
  }

  @Nullable
  @Override
  public ExecutionBranchNode branchNode() {
    return branchNode;
  }

  @Override
  public int attempts() {
    return attempts;
  }

  @Override
  public String toString() {
    return "ExecutionNode{"
        + "nodeId=" + nodeId + ", "
        + "upstreamNodeIds=" + upstreamNodeIds + ", "
        + "bindings=" + bindings + ", "
        + "runnableNode=" + runnableNode + ", "
        + "subWorkflow=" + subWorkflow + ", "
        + "branchNode=" + branchNode + ", "
        + "attempts=" + attempts
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExecutionNode) {
      ExecutionNode that = (ExecutionNode) o;
      return this.nodeId.equals(that.nodeId())
          && this.upstreamNodeIds.equals(that.upstreamNodeIds())
          && (this.bindings == null ? that.bindings() == null : this.bindings.equals(that.bindings()))
          && (this.runnableNode == null ? that.runnableNode() == null : this.runnableNode.equals(that.runnableNode()))
          && (this.subWorkflow == null ? that.subWorkflow() == null : this.subWorkflow.equals(that.subWorkflow()))
          && (this.branchNode == null ? that.branchNode() == null : this.branchNode.equals(that.branchNode()))
          && this.attempts == that.attempts();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= nodeId.hashCode();
    h$ *= 1000003;
    h$ ^= upstreamNodeIds.hashCode();
    h$ *= 1000003;
    h$ ^= (bindings == null) ? 0 : bindings.hashCode();
    h$ *= 1000003;
    h$ ^= (runnableNode == null) ? 0 : runnableNode.hashCode();
    h$ *= 1000003;
    h$ ^= (subWorkflow == null) ? 0 : subWorkflow.hashCode();
    h$ *= 1000003;
    h$ ^= (branchNode == null) ? 0 : branchNode.hashCode();
    h$ *= 1000003;
    h$ ^= attempts;
    return h$;
  }

  static final class Builder extends ExecutionNode.Builder {
    private String nodeId;
    private List<String> upstreamNodeIds;
    private List<Binding> bindings;
    private RunnableNode runnableNode;
    private WorkflowTemplate subWorkflow;
    private ExecutionBranchNode branchNode;
    private int attempts;
    private byte set$0;
    Builder() {
    }
    @Override
    ExecutionNode.Builder nodeId(String nodeId) {
      if (nodeId == null) {
        throw new NullPointerException("Null nodeId");
      }
      this.nodeId = nodeId;
      return this;
    }
    @Override
    ExecutionNode.Builder upstreamNodeIds(List<String> upstreamNodeIds) {
      if (upstreamNodeIds == null) {
        throw new NullPointerException("Null upstreamNodeIds");
      }
      this.upstreamNodeIds = upstreamNodeIds;
      return this;
    }
    @Override
    ExecutionNode.Builder bindings(List<Binding> bindings) {
      this.bindings = bindings;
      return this;
    }
    @Override
    ExecutionNode.Builder runnableNode(RunnableNode runnableNode) {
      this.runnableNode = runnableNode;
      return this;
    }
    @Override
    ExecutionNode.Builder subWorkflow(WorkflowTemplate subWorkflow) {
      this.subWorkflow = subWorkflow;
      return this;
    }
    @Override
    ExecutionNode.Builder branchNode(ExecutionBranchNode branchNode) {
      this.branchNode = branchNode;
      return this;
    }
    @Override
    ExecutionNode.Builder attempts(int attempts) {
      this.attempts = attempts;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    ExecutionNode build() {
      if (set$0 != 1
          || this.nodeId == null
          || this.upstreamNodeIds == null) {
        StringBuilder missing = new StringBuilder();
        if (this.nodeId == null) {
          missing.append(" nodeId");
        }
        if (this.upstreamNodeIds == null) {
          missing.append(" upstreamNodeIds");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" attempts");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExecutionNode(
          this.nodeId,
          this.upstreamNodeIds,
          this.bindings,
          this.runnableNode,
          this.subWorkflow,
          this.branchNode,
          this.attempts);
    }
  }

}
