/*
 * Decompiled with CFR 0.152.
 */
package org.flyte.jflyte.gcp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.flyte.jflyte.api.Token;
import org.flyte.jflyte.api.TokenSource;
import org.flyte.jflyte.gcp.GoogleAuthHelper;

class GcpTokenSource
implements TokenSource {
    private final GoogleAuthHelper authHelper;
    private final String targetAudience;
    private Token token;

    GcpTokenSource(GoogleAuthHelper auth, String targetAudience) {
        this.authHelper = Objects.requireNonNull(auth, "auth");
        this.targetAudience = Objects.requireNonNull(targetAudience, "targetAudience");
    }

    public synchronized Token token() {
        try {
            if (this.token == null) {
                this.token = this.authHelper.getToken(this.targetAudience);
            }
            return this.token;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to generate token", e);
        }
    }
}

