/*
 * Decompiled with CFR 0.152.
 */
package org.flyte.jflyte.gcp;

import com.google.api.client.googleapis.util.Utils;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.util.Objects;
import org.flyte.jflyte.api.TokenSource;
import org.flyte.jflyte.api.TokenSourceFactory;
import org.flyte.jflyte.gcp.GcpTokenSource;
import org.flyte.jflyte.gcp.GoogleAuthHelper;

public class GcpTokenSourceFactory
implements TokenSourceFactory {
    private final String targetAudience;

    public GcpTokenSourceFactory(String targetAudience) {
        this.targetAudience = Objects.requireNonNull(targetAudience, "targetDuration");
    }

    public String getMethod() {
        return "id_token";
    }

    public TokenSource getTokenSource() {
        Clock clock = Clock.systemUTC();
        return new GcpTokenSource(new GoogleAuthHelper(Utils.getDefaultTransport(), GcpTokenSourceFactory.getCredentials(), clock), this.targetAudience);
    }

    private static GoogleCredentials getCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

