/*
 * Decompiled with CFR 0.152.
 */
package org.flyte.jflyte.gcp;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.flyte.jflyte.api.TokenSourceFactory;
import org.flyte.jflyte.api.TokenSourceFactoryRegistrar;
import org.flyte.jflyte.gcp.GcpTokenSourceFactory;

@AutoService(value={TokenSourceFactoryRegistrar.class})
public class GcpTokenSourceFactoryRegistrar
extends TokenSourceFactoryRegistrar {
    static final String FLYTE_PLATFORM_URL = "FLYTE_PLATFORM_URL";
    private final Function<String, TokenSourceFactory> factoryFn;

    public GcpTokenSourceFactoryRegistrar() {
        this(GcpTokenSourceFactory::new);
    }

    @VisibleForTesting
    GcpTokenSourceFactoryRegistrar(Function<String, TokenSourceFactory> factoryFn) {
        this.factoryFn = Objects.requireNonNull(factoryFn);
    }

    public Iterable<TokenSourceFactory> load(Map<String, String> env) {
        String platformUrl = env.get(FLYTE_PLATFORM_URL);
        Preconditions.checkArgument((!Strings.nullToEmpty((String)platformUrl).trim().isEmpty() ? 1 : 0) != 0, (Object)("FLYTE_PLATFORM_URL env var must be a non empty string: " + platformUrl));
        return Collections.singletonList(this.factoryFn.apply(platformUrl));
    }
}

