/*
 * Decompiled with CFR 0.152.
 */
package org.flyte.jflyte.gcp;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.MustBeClosed;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.flyte.jflyte.api.FileSystem;
import org.flyte.jflyte.api.Manifest;

public class GcsFileSystem
implements FileSystem {
    private static final String SCHEME = "gs";
    private static final Pattern GCS_URI = Pattern.compile("(?<SCHEME>[^:]+)://(?<BUCKET>[^/]+)(/(?<OBJECT>.*))?");
    private final Supplier<Storage> storage;

    GcsFileSystem(Supplier<Storage> storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    public String getScheme() {
        return SCHEME;
    }

    @MustBeClosed
    public ReadableByteChannel reader(String uri) {
        Blob blob = this.guard(() -> this.storage.get().get(GcsFileSystem.parseUri(uri)), () -> "Couldn't read resource: " + uri);
        if (blob == null) {
            throw new IllegalArgumentException("Resource doesn't exist: " + uri);
        }
        return blob.reader(new Blob.BlobSourceOption[0]);
    }

    public WritableByteChannel writer(String uri) {
        return (WritableByteChannel)this.guard(() -> this.storage.get().writer(BlobInfo.newBuilder((BlobId)GcsFileSystem.parseUri(uri)).build(), new Storage.BlobWriteOption[0]), () -> "Couldn't write resource: " + uri);
    }

    @Nullable
    public Manifest getManifest(String uri) {
        Blob blob = this.guard(() -> this.storage.get().get(GcsFileSystem.parseUri(uri)), () -> "Couldn't get manifest for resource: " + uri);
        if (blob == null) {
            return null;
        }
        return Manifest.create();
    }

    private <T> T guard(Callable<T> callable, Supplier<String> errMessageSupplier) {
        try {
            return callable.call();
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(errMessageSupplier.get(), e);
        }
    }

    @VisibleForTesting
    static BlobId parseUri(String str) {
        URI uri = URI.create(str);
        Preconditions.checkArgument((boolean)uri.getScheme().equalsIgnoreCase(SCHEME), (String)"Invalid GCS URI scheme [%s]", (Object)uri);
        Preconditions.checkArgument((uri.getPort() == -1 ? 1 : 0) != 0, (String)"Invalid GCS URI port [%s]", (Object)uri);
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getFragment()), (String)"Invalid GCS URI fragment [%s]", (Object)uri);
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getQuery()), (String)"Invalid GCS URI query [%s]", (Object)uri);
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getUserInfo()), (String)"Invalid GCS URI userInfo [%s]", (Object)uri);
        Matcher m = GCS_URI.matcher(str);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Invalid GCS URI [%s]", (Object)uri);
        return BlobId.of((String)m.group("BUCKET"), (String)m.group("OBJECT"));
    }
}

