/*
 * Decompiled with CFR 0.152.
 */
package org.flyte.jflyte.gcp;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auto.service.AutoService;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.flyte.jflyte.api.FileSystem;
import org.flyte.jflyte.api.FileSystemRegistrar;
import org.flyte.jflyte.gcp.GcsFileSystem;

@AutoService(value={FileSystemRegistrar.class})
public class GcsFileSystemRegistrar
extends FileSystemRegistrar {
    private static final Logger LOG = Logger.getLogger(GcsFileSystemRegistrar.class.getName());
    private static final String FLYTE_GCP_IMPERSONATE_SERVICE_ACCOUNT_KEY = "FLYTE_GCP_IMPERSONATE_SERVICE_ACCOUNT";

    public Iterable<FileSystem> load(Map<String, String> env) {
        java.util.function.Supplier<Storage> storageSupplier = () -> {
            Credentials credentials = GcsFileSystemRegistrar.getCredentials(env);
            StorageOptions options = ((StorageOptions.Builder)StorageOptions.getDefaultInstance().toBuilder().setCredentials(credentials)).build();
            return (Storage)options.getService();
        };
        return Collections.singletonList(new GcsFileSystem(GcsFileSystemRegistrar.memoize(storageSupplier)));
    }

    static <T> java.util.function.Supplier<T> memoize(java.util.function.Supplier<T> supplier) {
        return () -> ((Supplier)Suppliers.memoize(supplier::get)).get();
    }

    private static Credentials getCredentials(Map<String, String> env) {
        String impersonateServiceAccount = env.get(FLYTE_GCP_IMPERSONATE_SERVICE_ACCOUNT_KEY);
        try {
            GoogleCredentials sourceCredentials = GoogleCredentials.getApplicationDefault();
            if (impersonateServiceAccount != null) {
                LOG.info(String.format("Using impersonated credentials [%s]", impersonateServiceAccount));
                return ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)impersonateServiceAccount, null, (List)ImmutableList.of((Object)"https://www.googleapis.com/auth/devstorage.read_write"), (int)3600);
            }
            return sourceCredentials;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        LOG.setLevel(Level.ALL);
    }
}

