/*
 * Decompiled with CFR 0.152.
 */
package org.flyte.jflyte.gcp;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.UserCredentials;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.logging.Logger;
import org.flyte.jflyte.api.Token;

class GoogleAuthHelper {
    private static final Logger LOG = Logger.getLogger(GoogleAuthHelper.class.getName());
    private static final JsonFactory JSON_FACTORY = Utils.getDefaultJsonFactory();
    private final HttpTransport httpTransport;
    private final GoogleCredentials credentials;
    private final Clock clock;

    GoogleAuthHelper(HttpTransport httpTransport, GoogleCredentials credentials, Clock clock) {
        this.httpTransport = Objects.requireNonNull(httpTransport, "httpTransport");
        this.credentials = Objects.requireNonNull(credentials, "credentials");
        this.clock = Objects.requireNonNull(clock, "clock");
    }

    public Token getToken(String targetAudience) throws IOException {
        if (this.credentials instanceof IdTokenProvider) {
            return this.getIdTokenFromIdTokenProvider(targetAudience);
        }
        if (this.credentials instanceof UserCredentials) {
            return this.getUserToken((UserCredentials)this.credentials);
        }
        throw new UnsupportedOperationException("Don't support credentials: " + this.credentials.getClass());
    }

    private Token getIdTokenFromIdTokenProvider(String targetAudience) throws IOException {
        LOG.info("Fetching token from provider");
        IdTokenCredentials idTokenCredentials = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)this.credentials).setTargetAudience(targetAudience).build();
        idTokenCredentials.refresh();
        IdToken idToken = idTokenCredentials.getIdToken();
        if (idToken == null || idToken.getTokenValue() == null) {
            throw new IOException("Couldn't get id token for credential");
        }
        Instant expiryAt = idToken.getExpirationTime().toInstant();
        return Token.builder().accessToken(idToken.getTokenValue()).expiry(expiryAt).tokenType("Bearer").build();
    }

    private Token getUserToken(UserCredentials credentials) throws IOException {
        LOG.info("Fetching user id token for user credential: " + credentials.getClientId());
        RefreshTokenRequest request = this.getRefreshTokenRequest(credentials);
        Instant base = this.clock.instant();
        IdTokenResponse response = (IdTokenResponse)request.executeUnparsed().parseAs(IdTokenResponse.class);
        if (response == null || response.getIdToken() == null) {
            String errMessage = String.format("Couldn't get id token for user credential: [%s].%nUserCredentials can obtain an id token only when authenticated through gcloud running 'gcloud auth login --update-adc' or 'gcloud auth application-default login'", credentials.getClientId());
            throw new IOException(errMessage);
        }
        Instant expiryAt = base.plusSeconds(response.getExpiresInSeconds());
        return Token.builder().accessToken(response.getIdToken()).expiry(expiryAt).tokenType(response.getTokenType()).build();
    }

    private RefreshTokenRequest getRefreshTokenRequest(UserCredentials credentials) {
        return new RefreshTokenRequest(this.httpTransport, JSON_FACTORY, new GenericUrl(credentials.toBuilder().getTokenServerUri()), credentials.getRefreshToken()).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(credentials.getClientId(), credentials.getClientSecret())).setRequestInitializer((HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials));
    }
}

