/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.forkjoin.jdbckit.mysql.CacheDaoImplCreate;
import org.forkjoin.jdbckit.mysql.Config;
import org.forkjoin.jdbckit.mysql.DaoImplCreate;
import org.forkjoin.jdbckit.mysql.ObjectCreate;
import org.forkjoin.jdbckit.mysql.ReadOnlyDaoImplCreate;
import org.forkjoin.jdbckit.mysql.SpringXmlCreate;
import org.forkjoin.jdbckit.mysql.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder {
    private static final Logger log = LoggerFactory.getLogger(Builder.class);
    private Config config;
    private List<Table> list;

    public Builder(Config config, Connection conn) throws SQLException {
        this.config = config;
        log.info("\u521d\u59cb\u5316\u6570\u636e\u5e93\u4fe1\u606f");
        DatabaseMetaData dm = conn.getMetaData();
        log.info("\u6570\u636e\u5e93\u7cfb\u7edf\u540d\u8bcd:" + dm.getDatabaseProductName());
        log.info("\u6570\u636e\u5e93\u7cfb\u7edf\u7248\u672c:" + dm.getDatabaseProductVersion());
        ResultSet rs = dm.getTables(null, null, null, null);
        this.list = Lists.newArrayList();
        while (rs.next()) {
            String type = String.valueOf(rs.getObject("TABLE_TYPE"));
            String name = String.valueOf(rs.getObject("TABLE_NAME"));
            String remark = String.valueOf(rs.getObject("REMARKS"));
            if (!type.equals("TABLE")) continue;
            Table t = new Table(config.getTablePrefix(), conn, dm, name, type, remark);
            this.list.add(t);
        }
        rs.close();
    }

    public void objectCreate() throws Exception {
        ObjectCreate.create(this.list, this.config, this.config.getObjectPack());
    }

    public void daoImplCreate() throws Exception {
        DaoImplCreate.create(this.list, this.config, this.config.getObjectPack(), this.config.getDaoPack(), null);
    }

    public void springXmlCreate() throws Exception {
        SpringXmlCreate.create(SpringXmlCreate.Type.BASE, this.list, this.config, this.config.getObjectPack(), this.config.getDaoPack(), "impl");
    }

    public void readOnlyDaoImplCreate() throws Exception {
        ReadOnlyDaoImplCreate.create(this.list, this.config, this.config.getObjectPack(), this.config.getDaoPack() + ".readonly", null);
    }

    public void readOnlySpringXmlCreate() throws Exception {
        SpringXmlCreate.create(SpringXmlCreate.Type.READ_ONLY, this.list, this.config, this.config.getObjectPack(), this.config.getDaoPack(), "impl");
    }

    public void cacheDaoImplCreate() throws Exception {
        CacheDaoImplCreate.create(this.list, this.config, this.config.getObjectPack(), this.config.getDaoPack() + ".cache", null);
    }

    public void cacheSpringXmlCreate() throws Exception {
        SpringXmlCreate.create(SpringXmlCreate.Type.CACHE, this.list, this.config, this.config.getObjectPack(), this.config.getDaoPack(), "impl");
    }
}

