/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.forkjoin.jdbckit.mysql.NameUtils;

public class Column {
    private String name;
    private String remark;
    private String typeName;
    private int type;
    private boolean autoIncrement;
    private boolean nullable;
    private int size;
    private boolean isUnique;
    private String mapClassName;
    private String mapClassNameGeneric;
    private OBJECT_TYPE objectType;
    private int seq;
    private static final Pattern GENERIC_PATTERN = Pattern.compile("([^<]+)<[^>]+>.*");

    public String getSetName() {
        return "set" + NameUtils.toClassName(this.name);
    }

    public String getConstantName() {
        return this.name.toUpperCase();
    }

    public String getFieldName() {
        return NameUtils.toFieldName(this.name);
    }

    public String getGetName() {
        return "get" + NameUtils.toClassName(this.name);
    }

    public String getDbName() {
        return this.name;
    }

    public boolean isDateColumn() {
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            // empty if block
        }
        return false;
    }

    public String getResultGetMethod() {
        switch (this.type) {
            case -6: {
                return "getByte";
            }
            case 5: {
                return "getShort";
            }
            case -5: {
                return "getLong";
            }
            case -7: {
                return "getBoolean";
            }
            case -4: 
            case 2004: {
                return "getBlob";
            }
            case 16: {
                return "getBoolean";
            }
            case 1: {
                return "getString";
            }
            case 2005: {
                return "getClob";
            }
            case 91: {
                return "getDate";
            }
            case 3: {
                return "getBigDecimal";
            }
            case 2: {
                return "getBigDecimal";
            }
            case 8: {
                return "getDouble";
            }
            case 6: {
                return "getFloat";
            }
            case 4: {
                return "getInt";
            }
            case 92: {
                return "getTime";
            }
            case 93: {
                return "getTimestamp";
            }
            case 12: {
                return "getString";
            }
            case -16: {
                return "getString";
            }
            case -1: {
                return "getString";
            }
            case 7: {
                if (this.typeName.equals("FLOAT")) {
                    return "getFloat";
                }
                throw new RuntimeException("\u672a\u5b9e\u73b0");
            }
        }
        return "getObject";
    }

    public void setMapClassNameGeneric(String mapClassNameGeneric) {
        this.mapClassNameGeneric = mapClassNameGeneric;
    }

    public String getInitString() {
        if (this.nullable) {
            return "null";
        }
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return "0";
            }
            case 16: {
                return "false";
            }
            case 7: {
                if (this.typeName.equals("FLOAT")) {
                    return "0";
                }
                throw new RuntimeException("\u672a\u5b9e\u73b0");
            }
        }
        return "null";
    }

    public String getWrapClassName() {
        if (this.mapClassName != null) {
            return this.mapClassName;
        }
        switch (this.type) {
            case -6: {
                return "Byte";
            }
            case 5: {
                return "Short";
            }
            case -5: {
                return "Long";
            }
            case -7: {
                return "Boolean";
            }
            case -4: 
            case 2004: {
                return "java.sql.Blob";
            }
            case 16: {
                return "Boolean";
            }
            case 1: {
                return "String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 3: {
                return "java.math.BigDecimal";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 8: {
                return "Double";
            }
            case 6: {
                return "Float";
            }
            case 4: {
                return "Integer";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.util.Date";
            }
            case 12: {
                return "String";
            }
            case -16: {
                return "String";
            }
            case -1: {
                return "String";
            }
            case 7: {
                if (this.typeName.equals("FLOAT")) {
                    return "Float";
                }
                throw new RuntimeException("\u672a\u5b9e\u73b0");
            }
        }
        return "Object";
    }

    public String getClassNameNoGeneric() {
        if (this.mapClassNameGeneric != null) {
            return this.mapClassNameGeneric;
        }
        return this.getClassName();
    }

    public String getClassName() {
        if (this.mapClassName != null) {
            return this.mapClassName;
        }
        switch (this.type) {
            case -6: {
                return this.nullable ? "Byte" : "byte";
            }
            case 5: {
                return this.nullable ? "Short" : "short";
            }
            case -5: {
                return this.nullable ? "Long" : "long";
            }
            case -7: {
                return this.nullable ? "Boolean" : "boolean";
            }
            case -4: 
            case 2004: {
                return "java.sql.Blob";
            }
            case 16: {
                return this.nullable ? "Boolean" : "boolean";
            }
            case 1: {
                return "String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 3: {
                return "java.math.BigDecimal";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 8: {
                return this.nullable ? "Double" : "double";
            }
            case 6: {
                return this.nullable ? "Float" : "float";
            }
            case 4: {
                return this.nullable ? "Integer" : "int";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.util.Date";
            }
            case 12: {
                return "String";
            }
            case -16: {
                return "String";
            }
            case -1: {
                return "String";
            }
            case 7: {
                if (this.typeName.equals("FLOAT")) {
                    return this.nullable ? "Float" : "float";
                }
                throw new RuntimeException("\u672a\u5b9e\u73b0");
            }
        }
        return "Object";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public String getMapClassName() {
        return this.mapClassName;
    }

    public void setMapClassName(String mapClassName) {
        this.mapClassName = mapClassName;
        Matcher m = GENERIC_PATTERN.matcher(mapClassName);
        if (m.find()) {
            this.setMapClassNameGeneric(m.group(1));
        }
    }

    public int getObjectType() {
        return this.objectType.ordinal();
    }

    public void setObjectType(OBJECT_TYPE objectType) {
        this.objectType = objectType;
    }

    public String toString() {
        return "Column [name=" + this.name + ", remark=" + this.remark + ", typeName=" + this.typeName + ", type=" + this.type + ", autoIncrement=" + this.autoIncrement + ", nullable=" + this.nullable + ", size=" + this.size + ", isUnique=" + this.isUnique + ", mapClassName=" + this.mapClassName + ", objectType=" + (Object)((Object)this.objectType) + ", seq=" + this.seq + "]";
    }

    public static enum OBJECT_TYPE {
        NORMAL,
        XML,
        JSON;

    }
}

