/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.forkjoin.jdbckit.mysql.Config;
import org.forkjoin.jdbckit.mysql.HttlUtils;
import org.forkjoin.jdbckit.mysql.SqlUtils;
import org.forkjoin.jdbckit.mysql.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCreate {
    private static final Logger log = LoggerFactory.getLogger(ObjectCreate.class);

    public static void create(List<Table> tl, Config config, String childPack) throws Exception {
        File dir = config.getPackPath(childPack);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("\u521b\u5efa\u8def\u5f84\u5931\u8d25:" + dir.getAbsolutePath());
        }
        for (Table ta : tl) {
            File f = new File(dir, ta.getClassName() + "DO.java");
            log.debug("ObjectCreate file:{}", (Object)f.getAbsolutePath());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            Throwable throwable = null;
            try {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("t", ta);
                context.put("sql", new SqlUtils());
                context.put("pack", config.getPack(childPack));
                HttlUtils.render("/org/forkjoin/jdbckit/mysql/template/object.httl", context, out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)out).close();
            }
        }
    }
}

