/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import org.forkjoin.jdbckit.mysql.Config;
import org.forkjoin.jdbckit.mysql.HttlUtils;
import org.forkjoin.jdbckit.mysql.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringXmlCreate {
    private static final Logger log = LoggerFactory.getLogger(SpringXmlCreate.class);

    public static void create(Type type, List<Table> tl, Config config, String objectPack, String daoPack, String daoImplPack) throws Exception {
        File dir = config.getResourcesPackPath("");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("\u521b\u5efa\u8def\u5f84\u5931\u8d25:" + dir.getAbsolutePath());
        }
        File f = new File(dir, type.contextFileName);
        log.debug("ObjectCreate file:{}", (Object)f.getAbsolutePath());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            HashMap<String, Object> context = new HashMap<String, Object>();
            String pack = config.getPack(daoPack);
            context.put("pack", pack + type.packName);
            context.put("tables", tl);
            context.put("anotherName", type.anotherName);
            HttlUtils.render("/org/forkjoin/jdbckit/mysql/template/springContextImpl.httl", context, out);
        }
    }

    public static enum Type {
        BASE("DaoContext.xml", "", ""),
        READ_ONLY("ReadOnlyDaoContext.xml", ".readonly", "ReadOnly"),
        CACHE("CacheDaoContext.xml", ".cache", "Cache");

        final String contextFileName;
        final String packName;
        final String anotherName;

        private Type(String contextFileName, String packName, String anotherName) {
            this.contextFileName = contextFileName;
            this.packName = packName;
            this.anotherName = anotherName;
        }
    }
}

