/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import org.forkjoin.jdbckit.mysql.Column;
import org.forkjoin.jdbckit.mysql.Table;

public class SqlUtils {
    public String toInsertSql(Table t) {
        StringBuilder sb = new StringBuilder("INSERT INTO `");
        sb.append(t.getDbName());
        sb.append("` (");
        this.toSqlColumn(t, sb);
        sb.append(") VALUES (");
        this.toSqlColumnPlaceholder(t, sb);
        sb.append(')');
        return sb.toString();
    }

    public String toReplaceSql(Table t) {
        StringBuilder sb = new StringBuilder("REPLACE INTO `");
        sb.append(t.getDbName());
        sb.append("` (");
        this.toSqlAllColumn(t, sb);
        sb.append(") VALUES (");
        this.toSqlAllColumnPlaceholder(t, sb);
        sb.append(')');
        return sb.toString();
    }

    public String toInsertPrefix(Table t) {
        StringBuilder sb = new StringBuilder("INSERT INTO `");
        sb.append(t.getDbName());
        sb.append("` (");
        this.toSqlColumn(t, sb);
        sb.append(") VALUES ");
        return sb.toString();
    }

    public String toInsertValueItems(Table t) {
        StringBuilder sb = new StringBuilder(" (");
        this.toSqlColumnPlaceholder(t, sb);
        sb.append(") ");
        return sb.toString();
    }

    public String toUpdateTable(Table t) {
        StringBuilder sb = new StringBuilder("UPDATE `");
        sb.append(t.getDbName());
        sb.append("` SET ");
        this.toSqlSetlColumn(t, sb);
        sb.append(" WHERE ");
        this.toSqlKeyWhere(t, sb);
        return sb.toString();
    }

    public String toUpdatePartialPrefix(Table t) {
        StringBuilder sb = new StringBuilder("UPDATE `");
        sb.append(t.getDbName());
        sb.append("` SET ");
        return sb.toString();
    }

    public String toWhereByKey(Table t) {
        StringBuilder sb = new StringBuilder(" WHERE ");
        this.toSqlKeyWhere(t, sb);
        return sb.toString();
    }

    public String toDelete(Table t) {
        StringBuilder sb = new StringBuilder("DELETE FROM `");
        sb.append(t.getDbName());
        sb.append("` WHERE ");
        this.toSqlKeyWhere(t, sb);
        return sb.toString();
    }

    public String toSelectByKey(Table t) {
        StringBuilder sb = new StringBuilder("SELECT * FROM `");
        sb.append(t.getDbName());
        sb.append("` WHERE ");
        this.toSqlKeyWhere(t, sb);
        if (t.isKey()) {
            sb.append(" ORDER BY ");
        }
        this.toSqlOrderByKey(t, sb);
        return sb.toString();
    }

    public String toSelectCount(Table t) {
        StringBuilder sb = new StringBuilder("SELECT count(*) FROM `");
        sb.append(t.getDbName());
        sb.append('`');
        return sb.toString();
    }

    public String toFormatSelectAll(Table t) {
        StringBuilder sb = new StringBuilder("SELECT %s FROM `");
        sb.append(t.getDbName());
        sb.append('`');
        if (t.isKey()) {
            sb.append(" ORDER BY ");
        }
        this.toSqlOrderByKey(t, sb);
        return sb.toString();
    }

    public String toFormatSelectPrefix(Table t) {
        StringBuilder sb = new StringBuilder("SELECT %s FROM `");
        sb.append(t.getDbName());
        sb.append("` ");
        return sb.toString();
    }

    public String toSelectPrefix(Table t) {
        StringBuilder sb = new StringBuilder("SELECT * FROM `");
        sb.append(t.getDbName());
        sb.append("` ");
        return sb.toString();
    }

    public String toOrderBykey(Table t) {
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        this.toSqlOrderByKey(t, sb);
        return sb.toString();
    }

    public void toSqlOrderByKey(Table t, StringBuilder sb) {
        boolean first = true;
        for (Column c : t.getKeyColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append('`');
            sb.append(c.getDbName());
            sb.append("` DESC");
        }
    }

    public void toSqlKeyWhere(Table t, StringBuilder sb) {
        boolean first = true;
        for (Column c : t.getKeyColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(" AND ");
            }
            sb.append('`');
            sb.append(c.getDbName());
            sb.append("`=?");
        }
    }

    public void toSqlSetlColumn(Table t, StringBuilder sb) {
        if (t.getAllColumns().isEmpty()) {
            return;
        }
        boolean del = false;
        for (Column c : t.getNoIdColumns()) {
            sb.append('`');
            sb.append(c.getDbName());
            sb.append("`=?,");
            del = true;
        }
        if (del) {
            sb.setLength(sb.length() - 1);
        }
    }

    public void toSqlColumn(Table t, StringBuilder sb) {
        if (t.getAllColumns().isEmpty()) {
            return;
        }
        boolean del = false;
        for (Column c : t.getAllColumns()) {
            if (c.isAutoIncrement()) continue;
            sb.append('`');
            sb.append(c.getDbName());
            sb.append("`,");
            del = true;
        }
        if (del) {
            sb.setLength(sb.length() - 1);
        }
    }

    public void toSqlAllColumn(Table t, StringBuilder sb) {
        if (t.getAllColumns().isEmpty()) {
            return;
        }
        boolean del = false;
        for (Column c : t.getAllColumns()) {
            sb.append('`');
            sb.append(c.getDbName());
            sb.append("`,");
            del = true;
        }
        if (del) {
            sb.setLength(sb.length() - 1);
        }
    }

    public void toSqlColumnPlaceholder(Table t, StringBuilder sb) {
        if (t.getAllColumns().isEmpty()) {
            return;
        }
        boolean del = false;
        for (Column c : t.getAllColumns()) {
            if (c.isAutoIncrement()) continue;
            sb.append("?,");
            del = true;
        }
        if (del) {
            sb.setLength(sb.length() - 1);
        }
    }

    public void toSqlAllColumnPlaceholder(Table t, StringBuilder sb) {
        if (t.getAllColumns().isEmpty()) {
            return;
        }
        boolean del = false;
        for (Column c : t.getAllColumns()) {
            sb.append("?,");
            del = true;
        }
        if (del) {
            sb.setLength(sb.length() - 1);
        }
    }
}

