/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forkjoin.jdbckit.mysql.Column;
import org.forkjoin.jdbckit.mysql.NameUtils;
import org.forkjoin.jdbckit.mysql.UniqueIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table {
    private static final Pattern XML_PATTERN = Pattern.compile("XML:([^;]+);{1}(.*)");
    private static final Pattern JSON_PATTERN = Pattern.compile("JSON:([^;]+);{1}(.*)");
    private static final Logger log = LoggerFactory.getLogger(Table.class);
    private String name;
    private String type;
    private String schema;
    private String remark;
    private List<Column> allColumns = Lists.newArrayList();
    private Map<String, Column> allMap = Maps.newHashMap();
    private List<Column> noIdcolumns = Lists.newArrayList();
    private List<Column> keyColumns = Lists.newArrayList();
    private Column keyColumn;
    private boolean oneKey;
    private boolean key;
    private Map<String, UniqueIndex> uniqueIndexes = new HashMap<String, UniqueIndex>();
    private String tablePrefix;
    private static Random ran = new Random(System.nanoTime());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table(String tablePrefix, Connection con, DatabaseMetaData dm, String name, String type, String remark) throws SQLException {
        this.tablePrefix = tablePrefix;
        this.name = name;
        this.type = type;
        this.remark = remark;
        Statement st = con.createStatement();
        ResultSet rs = null;
        ResultSet r = null;
        ResultSet indexRs = null;
        try {
            String cname;
            log.debug("\u83b7\u53d6\u4e3b\u952e\u4fe1\u606f");
            r = dm.getPrimaryKeys(null, null, name);
            while (r.next()) {
                Column c = new Column();
                c.setName(String.valueOf(r.getObject("COLUMN_NAME")));
                c.setSeq(Integer.valueOf(String.valueOf(r.getObject("KEY_SEQ"))));
                this.keyColumns.add(c);
                this.allMap.put(c.getName(), c);
            }
            r.close();
            log.debug("\u6267\u884c\u67e5\u8be2\u8bed\u53e5:select * from `{}` limit 1", (Object)name);
            rs = st.executeQuery("select * from `" + name + "` limit 1");
            ResultSetMetaData ms = rs.getMetaData();
            this.schema = ms.getSchemaName(1);
            if (this.schema == null || this.schema.length() < 1) {
                this.schema = ms.getCatalogName(1);
            }
            r = dm.getColumns(null, null, name, null);
            int i = 1;
            while (r.next()) {
                cname = String.valueOf(r.getObject("COLUMN_NAME"));
                Column c = this.allMap.get(cname);
                if (c == null) {
                    c = new Column();
                    c.setName(cname);
                    this.allMap.put(cname, c);
                }
                this.allColumns.add(c);
                c.setAutoIncrement(ms.isAutoIncrement(i));
                c.setNullable("yes".equalsIgnoreCase(r.getString("IS_NULLABLE")));
                String cr = r.getString("REMARKS");
                c.setType(r.getInt("DATA_TYPE"));
                c.setSize(r.getInt("COLUMN_SIZE"));
                c.setTypeName(r.getString("TYPE_NAME"));
                Matcher m = XML_PATTERN.matcher(cr);
                if (m.find()) {
                    c.setMapClassName(m.group(1));
                    c.setRemark(m.group(2));
                    c.setObjectType(Column.OBJECT_TYPE.XML);
                } else {
                    m = JSON_PATTERN.matcher(cr);
                    if (m.find()) {
                        c.setMapClassName(m.group(1));
                        c.setRemark(m.group(2));
                        c.setObjectType(Column.OBJECT_TYPE.JSON);
                    } else {
                        c.setRemark(cr);
                        c.setObjectType(Column.OBJECT_TYPE.NORMAL);
                    }
                }
                if (!c.isAutoIncrement()) {
                    this.noIdcolumns.add(c);
                }
                ++i;
                log.debug("\u5b57\u6bb5\u4fe1\u606f:{}", (Object)c);
            }
            if (!this.keyColumns.isEmpty()) {
                Collections.sort(this.keyColumns, new Comparator<Column>(){

                    @Override
                    public int compare(Column o1, Column o2) {
                        return Integer.valueOf(o1.getSeq()).compareTo(o2.getSeq());
                    }
                });
                this.key = true;
            } else {
                this.key = false;
            }
            if (this.keyColumns.size() == 1) {
                this.oneKey = true;
                this.keyColumn = this.keyColumns.get(0);
            } else if (this.keyColumns.size() > 1) {
                this.oneKey = false;
                this.keyColumn = null;
            } else {
                this.oneKey = false;
                this.keyColumn = null;
            }
            indexRs = dm.getIndexInfo(null, null, name, true, false);
            while (indexRs.next()) {
                cname = String.valueOf(indexRs.getObject("COLUMN_NAME"));
                String indexName = String.valueOf(indexRs.getObject("INDEX_NAME"));
                int ordinalPosition = indexRs.getInt("ORDINAL_POSITION");
                this.addUniqueIndex(cname, indexName, ordinalPosition);
                Column c = this.allMap.get(cname);
                if (c == null) continue;
                c.setUnique(true);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (r != null) {
                r.close();
            }
            if (indexRs != null) {
                indexRs.close();
            }
            st.close();
        }
    }

    private void addUniqueIndex(String cname, String indexName, int ordinalPosition) {
        UniqueIndex uniqueIndex = this.uniqueIndexes.get(indexName);
        if (uniqueIndex == null) {
            uniqueIndex = new UniqueIndex(indexName);
            this.uniqueIndexes.put(indexName, uniqueIndex);
        }
        uniqueIndex.addField(cname, ordinalPosition);
    }

    public boolean isHasKeyConstructorArgs() {
        return !this.keyColumns.isEmpty();
    }

    public String getKeyConstructorArgs() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.keyColumns.size(); ++i) {
            Column c = this.keyColumns.get(i);
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(c.getClassName());
            sb.append(' ');
            sb.append(c.getFieldName());
        }
        return sb.toString();
    }

    public boolean isHasConstructorArgs() {
        return this.isHasConstructorArgs(this.allColumns);
    }

    public String getConstructorArgs() {
        return this.getConstructorArgsString(this.allColumns);
    }

    public boolean isHasConstructorArgs(List<Column> list) {
        for (int i = 0; i < list.size(); ++i) {
            Column c = list.get(i);
            if (c.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    private String getConstructorArgsString(List<Column> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Column c = list.get(i);
            if (c.isAutoIncrement()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(c.getClassName());
            sb.append(' ');
            sb.append(c.getFieldName());
        }
        return sb.toString();
    }

    public String getToString() {
        return this.getToStringString(this.allColumns);
    }

    public String getKeyToString() {
        return this.getToStringString(this.keyColumns);
    }

    private String getToStringString(List<Column> list) {
        StringBuilder sb = new StringBuilder("\"");
        sb.append(this.getClassName());
        sb.append("[");
        for (int i = 0; i < list.size(); ++i) {
            Column c = list.get(i);
            if (i != 0) {
                sb.append("+\",");
            }
            sb.append(c.getFieldName());
            sb.append(":\"+ ");
            if (String.class.getSimpleName().equals(c.getClassName())) {
                sb.append("(").append(c.getFieldName()).append(" == null ?\"null\":");
                sb.append(c.getFieldName()).append(".substring(0, Math.min(");
                sb.append(c.getFieldName()).append(".length(), 64)))");
                continue;
            }
            sb.append(c.getFieldName());
        }
        sb.append("+ \"]\"");
        return sb.toString();
    }

    public String getColumnNameString() {
        StringBuilder sb = new StringBuilder();
        for (Column c : this.noIdcolumns) {
            sb.append('`');
            sb.append(c.getName());
            sb.append('`');
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getColumnDbNameString() {
        StringBuilder sb = new StringBuilder();
        for (Column c : this.noIdcolumns) {
            sb.append('#');
            sb.append(c.getDbName());
            sb.append('#');
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public List<Column> getKeyColumns() {
        return this.keyColumns;
    }

    public boolean isHasDateColumns() {
        for (Column c : this.allColumns) {
            if (!c.isDateColumn()) continue;
            return true;
        }
        return false;
    }

    public String getColumnValuesDbNameString() {
        StringBuilder sb = new StringBuilder();
        for (Column c : this.noIdcolumns) {
            sb.append("#values[].");
            sb.append(c.getDbName());
            sb.append("#");
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getColumnUpdateString() {
        StringBuilder sb = new StringBuilder();
        for (Column c : this.noIdcolumns) {
            sb.append('`');
            sb.append(c.getName());
            sb.append('`');
            sb.append("=#");
            sb.append(c.getDbName());
            sb.append('#');
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getClassName() {
        if (this.tablePrefix != null && this.name.startsWith(this.tablePrefix)) {
            return NameUtils.toClassName(this.name.substring(this.tablePrefix.length()));
        }
        return NameUtils.toClassName(this.name);
    }

    public String getFieldName() {
        if (this.tablePrefix != null && this.name.startsWith(this.tablePrefix)) {
            return NameUtils.toFieldName(this.name.substring(this.tablePrefix.length()));
        }
        return NameUtils.toFieldName(this.name);
    }

    public String getKeysParameters() {
        if (this.keyColumns.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Column c : this.keyColumns) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(c.getClassName());
            sb.append(' ');
            sb.append(c.getFieldName());
        }
        return sb.toString();
    }

    public String getMethodParameters() {
        if (this.keyColumns.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Column c : this.keyColumns) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(c.getFieldName());
        }
        return sb.toString();
    }

    public String getFinalKeysParameters() {
        if (this.keyColumns.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Column c : this.keyColumns) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("final ");
            sb.append(c.getClassName());
            sb.append(' ');
            sb.append(c.getFieldName());
        }
        return sb.toString();
    }

    public String getDbName() {
        return this.name;
    }

    public String getSerialVersionUID() {
        return String.valueOf(ran.nextLong());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setAllColumns(List<Column> allColumns) {
        this.allColumns = allColumns;
    }

    public List<Column> getAllColumns() {
        return this.allColumns;
    }

    public List<Column> getNoIdColumns() {
        return this.noIdcolumns;
    }

    public Column getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(Column keyColumn) {
        this.keyColumn = keyColumn;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean isOneKey() {
        return this.oneKey;
    }

    public void setOneKey(boolean oneKey) {
        this.oneKey = oneKey;
    }

    public Map<String, UniqueIndex> getUniqueIndexes() {
        return this.uniqueIndexes;
    }
}

