/*
 * Decompiled with CFR 0.152.
 */
package org.forkjoin.jdbckit.mysql;

import java.util.TreeSet;
import org.apache.commons.lang3.StringEscapeUtils;

public class UniqueIndex {
    private String indexName;
    private TreeSet<Field> fields = new TreeSet();

    public UniqueIndex(String indexName) {
        this.indexName = indexName;
    }

    public void addField(String fieldName, int ordinalPosition) {
        Field field = new Field();
        field.fieldName = fieldName;
        field.ordinalPosition = ordinalPosition;
        this.fields.add(field);
    }

    public String getConstantName() {
        return this.indexName.toUpperCase();
    }

    public String toFieldsArgs() {
        StringBuilder sb = new StringBuilder();
        for (Field field : this.fields) {
            if (sb.length() > 0) {
                sb.append(" ,");
            }
            sb.append('\"');
            sb.append(StringEscapeUtils.escapeJava((String)field.fieldName));
            sb.append('\"');
        }
        return sb.toString();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public TreeSet<Field> getFields() {
        return this.fields;
    }

    public static class Field
    implements Comparable<Field> {
        private String fieldName;
        private int ordinalPosition;

        public String getFieldName() {
            return this.fieldName;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition;
        }

        @Override
        public int compareTo(Field o) {
            return Integer.compare(this.ordinalPosition, o.ordinalPosition);
        }

        public String toString() {
            return "Field{fieldName='" + this.fieldName + '\'' + ", ordinalPosition=" + this.ordinalPosition + '}';
        }
    }
}

