/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.credentialprovider;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.frankframework.credentialprovider.Credentials;
import org.frankframework.credentialprovider.ICredentialFactory;
import org.frankframework.credentialprovider.ICredentials;
import org.frankframework.credentialprovider.util.CredentialConstants;

public class KubernetesCredentialFactory
implements ICredentialFactory {
    protected static final Logger log = Logger.getLogger(KubernetesCredentialFactory.class.getName());
    public static final String K8_USERNAME = "credentialFactory.kubernetes.username";
    public static final String K8_PASSWORD = "credentialFactory.kubernetes.password";
    public static final String K8_MASTER_URL = "credentialFactory.kubernetes.masterUrl";
    public static final String K8_NAMESPACE_PROPERTY = "credentialFactory.kubernetes.namespace";
    public static final long CREDENTIALS_CACHE_DURATION_MILLIS = 60000L;
    protected static final String USERNAME_KEY = "username";
    protected static final String PASSWORD_KEY = "password";
    public static final String DEFAULT_NAMESPACE = "default";
    protected String namespace;
    private KubernetesClient client;
    protected List<Credentials> credentials;
    private long lastFetch = 0L;

    public void initialize() {
        CredentialConstants appConstants = CredentialConstants.getInstance();
        log.info("initializing KubernetesCredentialFactory");
        if (this.client == null) {
            this.client = new KubernetesClientBuilder().build();
        }
        String defaultNamespace = Optional.ofNullable(this.client.getNamespace()).orElse(DEFAULT_NAMESPACE);
        this.namespace = appConstants.getProperty(K8_NAMESPACE_PROPERTY, defaultNamespace);
        String k8Username = appConstants.getProperty(K8_USERNAME, null);
        String k8Passwd = appConstants.getProperty(K8_PASSWORD, null);
        String k8MasterURL = appConstants.getProperty(K8_MASTER_URL, null);
        Config config = this.client.getConfiguration();
        if (k8Username != null) {
            config.setUsername(k8Username);
        }
        if (k8Passwd != null) {
            config.setPassword(k8Passwd);
        }
        if (k8MasterURL != null) {
            config.setMasterUrl(k8MasterURL);
            log.info("Using Kubernetes master URL: " + k8MasterURL);
        }
        log.info("Fetching secrets from Kubernetes namespace: " + this.namespace);
        this.credentials = this.getCredentials();
        log.info("Loaded Credential amount from Kubernetes: " + this.credentials.size());
    }

    public boolean hasCredentials(String alias) {
        return this.getConfiguredAliases().contains(alias);
    }

    public ICredentials getCredentials(String alias, Supplier<String> defaultUsernameSupplier, Supplier<String> defaultPasswordSupplier) {
        if (StringUtils.isEmpty((CharSequence)alias)) {
            return new Credentials(null, defaultUsernameSupplier, defaultPasswordSupplier);
        }
        return (ICredentials)this.getCredentials().stream().filter(credential -> alias.equalsIgnoreCase(credential.getAlias())).findFirst().orElseThrow(() -> new NoSuchElementException("cannot obtain credentials from authentication alias [" + alias + "]: alias not found"));
    }

    public Collection<String> getConfiguredAliases() {
        return this.getCredentials().stream().map(Credentials::getAlias).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected synchronized List<Credentials> getCredentials() {
        if (this.lastFetch + 60000L > System.currentTimeMillis()) {
            return this.credentials;
        }
        List secrets = ((SecretList)((NonNamespaceOperation)this.client.secrets().inNamespace(this.namespace)).list()).getItems();
        this.lastFetch = System.currentTimeMillis();
        if (secrets.isEmpty()) {
            log.warning("No secrets found in namespace: " + this.namespace);
        }
        this.credentials = secrets.stream().map(secret -> new Credentials(secret.getMetadata().getName(), () -> KubernetesCredentialFactory.decodeFromSecret(secret, USERNAME_KEY), () -> KubernetesCredentialFactory.decodeFromSecret(secret, PASSWORD_KEY))).collect(Collectors.toList());
        return this.credentials;
    }

    protected static String decodeFromSecret(Secret secret, String key) {
        String foundKey = (String)secret.getData().get(key);
        if (StringUtils.isEmpty((CharSequence)foundKey)) {
            log.info("On Credential with alias [" + secret.getMetadata().getName() + "]: No value found for key: " + key);
            return null;
        }
        return new String(Base64.getDecoder().decode(foundKey));
    }

    public void close() {
        this.client.close();
    }

    void setClient(KubernetesClient client) {
        log.info("Setting Kubernetes client to: " + client.getClass().getName());
        this.client = client;
    }

    void clearTimer() {
        this.lastFetch = 0L;
    }
}

