/*
 * Decompiled with CFR 0.152.
 */
package org.fryskeakademy.configuration;

import com.vectorprint.StringConverter;
import com.vectorprint.configuration.EnhancedMap;
import com.vectorprint.configuration.Settings;
import com.vectorprint.configuration.decoration.CachingProperties;
import com.vectorprint.configuration.decoration.ParsingProperties;
import com.vectorprint.configuration.decoration.ReadonlyProperties;
import com.vectorprint.configuration.jaxb.SettingsFromJAXB;
import com.vectorprint.configuration.jaxb.SettingsXMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ApplicationScoped
public class PropertyResolver {
    public static final String CONFIG_FILE_URL = "configFileUrl";
    public static final String FROM_JAR = "fromJar";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PropertyResolver.class.getName());

    @Produces
    @Named(value="CONFIGPROPS")
    public EnhancedMap initSettings(@Named(value="configFileUrl") String configFileUrl, @Named(value="fromJar") Boolean fromJar) throws Exception {
        return this.readAsSettingsOrProperties(configFileUrl, fromJar);
    }

    private Reader getReader(String configFileUrl, boolean fromJar) throws IOException {
        InputStream is;
        InputStream inputStream = is = fromJar ? Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileUrl) : StringConverter.URL_PARSER.convert(configFileUrl).openStream();
        if (is == null) {
            throw new IllegalArgumentException(String.format("%s not readable. Reading from jar: %s", configFileUrl, fromJar));
        }
        return new InputStreamReader(is);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EnhancedMap readAsSettingsOrProperties(String url, boolean fromJar) throws Exception {
        try {
            try (Reader in = this.getReader(url, fromJar);){
                SettingsXMLHelper.validateXml((Reader)in);
            }
            in = this.getReader(url, fromJar);
            throwable = null;
            try {
                EnhancedMap enhancedMap = new SettingsFromJAXB().fromJaxb(this.getReader(url, fromJar));
                return enhancedMap;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (SAXException sAXException) {
            LOGGER.warn(String.format("%s does not contain settings xml, trying to parse settings directly", url));
            return new CachingProperties((EnhancedMap)new ReadonlyProperties((EnhancedMap)new ParsingProperties((EnhancedMap)new Settings(), new Reader[]{this.getReader(url, fromJar)})));
        }
    }
}

