/*
 * Decompiled with CFR 0.152.
 */
package org.fa.tei.validation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.SchematronException;
import org.fa.tei.validation.SchematronHelper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RngValidationHelper {
    private static final Schema schema;

    public static Schema getSchema() {
        return schema;
    }

    public static void validateXml(InputStream xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(Reader xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(URL xml) throws SAXException, IOException {
        RngValidationHelper.validateXml(xml.openStream());
    }

    public static void validateRngSchematron(URL xml) throws Exception {
        RngValidationHelper.validateXml(xml);
        RngValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(URL xml) throws IOException, SchematronException {
        Result result = SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new SchematronException(result.getValidationMessages().toString());
        }
    }

    public static void validateRngSchematron(String xml) throws IOException, SAXException, SchematronException {
        RngValidationHelper.validateXml(xml);
        RngValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(String xml) throws SchematronException {
        Result result = SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new SchematronException(result.getValidationMessages().toString());
        }
    }

    public static void validateXml(String xml) throws SAXException, IOException {
        RngValidationHelper.validateXml(new StringReader(xml));
    }

    public static void main(String[] args) throws IOException, SAXException {
        if (args != null && args.length > 0) {
            File f = new File(args[0]);
            if (f.isFile()) {
                RngValidationHelper.validateXml(new URL(args[0]));
            } else if (f.isDirectory()) {
                Files.walk(f.toPath(), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).forEach(p -> {
                    try {
                        RngValidationHelper.validateXml(p.toFile().toURI().toURL());
                    }
                    catch (IOException | SAXException e) {
                        System.err.println(p.toFile().getPath() + " invalid");
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    static {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0", "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory", RngValidationHelper.class.getClassLoader());
            schema = sf.newSchema(new Source[]{new SAXSource(new InputSource(RngValidationHelper.class.getResourceAsStream(RNG.DICTIONARIES_RNG.getPathInJar())))});
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static enum RNG {
        DICTIONARIES_RNG("/facustomization/rng/corpora_linguistics.rng");

        private final String rng;
        private String content;

        private RNG(String rng) {
            this.rng = rng;
        }

        public String getPathInJar() {
            return this.rng;
        }

        public String getContent() throws IOException {
            if (this.content == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                InputStream in = RngValidationHelper.class.getResourceAsStream(this.rng);
                int i = -1;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
                this.content = out.toString();
            }
            return this.content;
        }
    }
}

