/*
 * Decompiled with CFR 0.152.
 */
package org.fa.tei.validation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.SchematronException;
import org.fa.tei.validation.SchematronHelper;
import org.fa.tei.validation.ValidationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidationHelper {
    public static final String CLASSPATH_URI_DICTIONARY_XSD = "classpath:/facustomization/xsd/corpora_linguistics.xsd";
    private static final Schema schema;
    private static final JAXBContext JAXBCONTEXT;
    public static final String TEINS = "http://www.tei-c.org/ns/1.0";

    public static <T> T fromXML(Reader xml, Class<T> clazz) throws JAXBException {
        return ValidationHelper.fromXML(xml, clazz, true);
    }

    public static <T> T fromXML(Reader xml, Class<T> clazz, boolean validate) throws JAXBException {
        Object o;
        Unmarshaller um = JAXBCONTEXT.createUnmarshaller();
        if (validate) {
            um.setSchema(schema);
        }
        if ((o = um.unmarshal(xml)) instanceof JAXBElement) {
            return (T)((JAXBElement)o).getValue();
        }
        return clazz.cast(o);
    }

    public static String toXML(Object teiObject) throws JAXBException {
        StringWriter w = new StringWriter();
        ValidationHelper.toXML(teiObject, w, true);
        return ((Object)w).toString();
    }

    public static void toXML(Object teiObject, Writer w, boolean validate) throws JAXBException {
        Class<?> c;
        Marshaller m = JAXBCONTEXT.createMarshaller();
        if (validate) {
            m.setSchema(schema);
        }
        if ((c = teiObject.getClass()).isAnnotationPresent(XmlRootElement.class)) {
            m.marshal(teiObject, w);
        } else {
            JAXBElement jb = new JAXBElement(new QName(TEINS, c.getSimpleName()), c, teiObject);
            m.marshal((Object)jb, w);
        }
    }

    public static JAXBContext getJAXBCONTEXT() {
        return JAXBCONTEXT;
    }

    public static Schema getSchema() {
        return schema;
    }

    public static void validateXml(InputStream xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(Reader xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(URL xml) throws SAXException, IOException {
        ValidationHelper.validateXml(xml.openStream());
    }

    public static void validateXsdSchematron(URL xml) throws IOException, SchematronException, SAXException {
        ValidationHelper.validateXml(xml);
        ValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(URL xml) throws IOException, SchematronException {
        Result result = SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new ValidationException(result.getValidationMessages().toString());
        }
    }

    public static void validateXsdSchematron(String xml) throws Exception {
        ValidationHelper.validateXml(xml);
        ValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(String xml) throws SchematronException {
        Result result = SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new ValidationException(result.getValidationMessages().toString());
        }
    }

    public static void validateXml(String xml) throws SAXException, IOException {
        ValidationHelper.validateXml(new StringReader(xml));
    }

    public static void main(String[] args) throws IOException, SAXException {
        if (args != null && args.length > 0) {
            File f = new File(args[0]);
            if (f.isFile()) {
                ValidationHelper.validateXml(new URL(args[0]));
            } else if (f.isDirectory()) {
                Files.walk(f.toPath(), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).forEach(p -> {
                    try {
                        ValidationHelper.validateXml(p.toFile().toURI().toURL());
                    }
                    catch (IOException | SAXException e) {
                        System.err.println(p.toFile().getPath() + " invalid");
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    static {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = sf.newSchema(new Source[]{new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.XML_XSD.getPathInJar()))), new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.DCR_XSD.getPathInJar()))), new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.T_XSD.getPathInJar()))), new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.CORPUS_LINGUISTICS_XSD.getPathInJar())))});
            JAXBCONTEXT = JAXBContext.newInstance((String)"org.fa.tei.jaxb.facustomization");
        }
        catch (JAXBException | SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static enum XSD {
        DCR_XSD("/facustomization/xsd/dcr.xsd"),
        XML_XSD("/facustomization/xsd/xml.xsd"),
        T_XSD("/facustomization/xsd/t.xsd"),
        CORPUS_LINGUISTICS_XSD("/facustomization/xsd/corpora_linguistics.xsd");

        private final String xsd;
        private String content;

        private XSD(String xsd) {
            this.xsd = xsd;
        }

        public String getPathInJar() {
            return this.xsd;
        }

        public String getContent() throws IOException {
            if (this.content == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                InputStream in = ValidationHelper.class.getResourceAsStream(this.xsd);
                int i = -1;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
                this.content = out.toString();
            }
            return this.content;
        }
    }
}

