/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.DataModel;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jsf.AbstractController;
import org.fryske_akademy.jsf.Filtering;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.fryske_akademy.services.Auditing;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityController<E extends EntityInterface>
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractEntityController.class.getName());
    private E selected;
    private E newEntity;
    protected final Class<E> clazz;
    private boolean rememberTableState = true;
    protected static final String STATE = "state";
    protected static final String FILTERING = "filtering";

    public boolean isRememberTableState() {
        return this.rememberTableState && (!this.useFilterMechanism() || !this.isFiltering());
    }

    protected abstract boolean useFilterMechanism();

    protected boolean isFiltering() {
        return FILTERING.equals(FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(STATE));
    }

    public void setRememberTableState(boolean rememberTableState) {
        this.rememberTableState = rememberTableState;
    }

    public AbstractEntityController(Class<E> clazz) {
        this.clazz = clazz;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        this.selected = selected;
    }

    public E getNewEntity() {
        return this.newEntity;
    }

    public void setNewEntity(E newEntity) {
        this.newEntity = newEntity;
    }

    public void onRowSelect(SelectEvent event) {
        if (event != null) {
            this.setSelected((EntityInterface)event.getObject());
        }
    }

    public void prepareCreate() throws InstantiationException, IllegalAccessException {
        this.newEntity = (EntityInterface)this.clazz.newInstance();
        this.fillNew(this.newEntity);
    }

    public E create() throws Exception {
        return this.create(this.newEntity);
    }

    public E create(E e) throws Exception {
        return this.persist(e, AbstractController.PersistAction.CREATE, JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Created"));
    }

    public E create(RowEditEvent event) throws Exception {
        EntityInterface e = this.create((EntityInterface)event.getObject());
        this.refreshRow(event, e, true);
        return (E)e;
    }

    public abstract Filtering<E> getFiltering();

    public Object getFilterValue(String key) {
        return this.getFiltering().getFilters().get(key);
    }

    public String getFilterString(String key) {
        Object value = this.getFiltering().getFilters().get(key);
        return value == null ? null : String.valueOf(value);
    }

    public Map<String, Object> getFilters() {
        return this.getFiltering().getFilters();
    }

    public abstract String gotoPageContaining(E var1);

    protected abstract void fillCopy(E var1, E var2);

    protected void fillNew(E entity) {
    }

    public void copy() throws InstantiationException, IllegalAccessException {
        if (this.selected != null) {
            EntityInterface l = (EntityInterface)this.clazz.newInstance();
            this.fillCopy(l, this.selected);
            this.newEntity = l;
        }
    }

    public E update(RowEditEvent editEvent) throws Exception {
        EntityInterface t = this.update((EntityInterface)editEvent.getObject());
        this.refreshRow(editEvent, t, true);
        if (t.equals(this.selected)) {
            this.selected = t;
        }
        return (E)t;
    }

    public E update() throws Exception {
        this.selected = this.update(this.selected);
        return this.selected;
    }

    public E update(E e) throws Exception {
        return this.persist(e, AbstractController.PersistAction.UPDATE, JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Updated"));
    }

    public E save(RowEditEvent event) throws Exception {
        EntityInterface t = (EntityInterface)event.getObject();
        return (E)(t.isTransient() ? this.create(event) : this.update((E)event));
    }

    protected void refreshRow(RowEditEvent editEvent, EntityInterface e, boolean update) {
        if (editEvent.getComponent() instanceof DataTable && e != null && e.getId() != null) {
            List rows;
            DataTable dt = (DataTable)editEvent.getComponent();
            Object value = dt.getValue();
            List list = rows = value instanceof List ? (List)value : null;
            if (value instanceof DataModel && ((DataModel)value).getWrappedData() instanceof List) {
                rows = (List)((DataModel)value).getWrappedData();
            }
            if (rows != null && !rows.isEmpty() && dt.getRowIndex() > -1) {
                int rowIndex;
                int n = rowIndex = value instanceof DataModel ? ((DataModel)value).getRowIndex() : dt.getRowIndex();
                if (update) {
                    rows.set(rowIndex, e);
                } else {
                    rows.set(rowIndex, this.getCrudReadService().find(e.getId(), this.clazz));
                }
            } else {
                LOGGER.warn(String.format("Cannot refresh datatable row: %s", dt.getRowIndex()));
            }
        } else {
            LOGGER.warn(String.format("Cannot refresh datatable row for: %s", e));
        }
    }

    public void cancelRow(RowEditEvent editEvent) throws Exception {
        EntityInterface e = (EntityInterface)editEvent.getObject();
        if (e != null && e.getId() == null) {
            LOGGER.warn("canceling a transient entity, calling destroy");
            this.destroy(e);
            return;
        }
        this.refreshRow(editEvent, e, false);
    }

    public void destroy(E e) throws Exception {
        if (e == null) {
            LOGGER.warn("entity to destroy is null");
            return;
        }
        if (e.isTransient() || e.equals(this.newEntity)) {
            this.setNewEntity(null);
        } else {
            this.persist(e, AbstractController.PersistAction.DELETE, JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Deleted"));
        }
        if (e.equals(this.selected)) {
            this.setSelected(null);
        }
    }

    public E toDelete() {
        return this.newEntity != null && this.selected == null ? this.newEntity : this.selected;
    }

    public void destroy() throws Exception {
        this.destroy(this.toDelete());
    }

    public boolean disableDelete() {
        return this.toDelete() == null;
    }

    public String deleteTitle() {
        return this.deleteTitle(this.toDelete());
    }

    public String deleteTitle(E entity) {
        if (entity == null) {
            return "";
        }
        Converter converter = JsfUtil.getConverter(entity.getClass());
        return entity == null ? "" : JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Delete") + " " + (converter == null ? entity : converter.getAsString(null, null, entity)) + "?";
    }

    protected Auditing getAuditing() {
        if (this.getCrudReadService() instanceof Auditing) {
            return (Auditing)this.getCrudReadService();
        }
        throw new IllegalStateException("getCrudReadService() does not return an instance of Auditing");
    }

    public String getLastChangedInfo(E entity) {
        List revisions = this.getAuditing().getRevisionInfo(entity.getId(), Integer.valueOf(1), this.clazz);
        if (revisions.isEmpty()) {
            return "no changes";
        }
        RevInfo rev = (RevInfo)revisions.get(0);
        return rev.getRevisionInfo().getUsername() + " at " + rev.getRevisionInfo().getRevisionDate() + " (" + rev.getType() + ")";
    }

    public List<RevInfo<E>> getLastChanged(E entity, int max) {
        return this.getAuditing().getRevisionInfo(entity, Integer.valueOf(max), this.clazz);
    }

    protected String filterAndRedirect(AbstractEntityController controller, String key, String value, String action) {
        controller.getFiltering().clear().add(key, value);
        return action + "?faces-redirect=true" + "&" + STATE + "=" + FILTERING;
    }
}

