/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.inject.Inject;
import javax.security.enterprise.SecurityContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fryske_akademy.Util;
import org.fryske_akademy.jsf.util.CookieHelper;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
public class SessionBean
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionBean.class);
    public static final String LANGUAGE_COOKIE = "language";
    public static final String THEME_COOKIE = "theme";
    private String language;
    private Locale locale;
    private static final Map<String, Locale> languageLocales = new HashMap<String, Locale>(3);
    private static final List<String> languages = new ArrayList<String>(3);
    private final List<String> themes = new ArrayList<String>(40);
    private String currentTheme;
    @Inject
    private transient SecurityContext securityContext;
    private final Map<String, Boolean> allowed;
    private String user;

    public SessionBean() {
        this.addTheme("aristo").addTheme("omega");
        this.currentTheme = this.themes.get(1);
        this.allowed = new HashMap<String, Boolean>(10);
    }

    protected SessionBean addTheme(String theme) {
        if (!this.themes.contains(theme)) {
            this.themes.add(theme);
        }
        return this;
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.securityContext = (SecurityContext)Util.getBean(SecurityContext.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    private void init() {
        this.initLanguages();
        if (!languageLocales.isEmpty()) {
            this.setLanguage((String)((Map.Entry)languageLocales.entrySet().stream().findFirst().get()).getKey());
        }
        this.initFromCookies();
    }

    public List<String> getThemes() {
        return this.themes;
    }

    public String getCurrentTheme() {
        return this.currentTheme;
    }

    public void setCurrentTheme(String currentTheme) {
        if (!this.themes.contains(currentTheme)) {
            throw new IllegalArgumentException(currentTheme + " not supported");
        }
        this.currentTheme = currentTheme;
    }

    public void themeChanged(ValueChangeEvent event) {
        this.setCurrentTheme((String)event.getNewValue());
        SessionBean.setCookie(THEME_COOKIE, this.currentTheme);
    }

    protected void addLanguage(String name, String code, String region) {
        languageLocales.put(name, new Locale(code, region));
        if (!languages.contains(name)) {
            languages.add(name);
        }
    }

    @Deprecated
    protected static void setCookie(String name, String value) {
        FacesContext context = FacesContext.getCurrentInstance();
        CookieHelper.replaceCookie(name, value, 31536000, (HttpServletRequest)context.getExternalContext().getRequest(), (HttpServletResponse)context.getExternalContext().getResponse());
    }

    @Deprecated
    protected static String getCookie(String name) {
        FacesContext context = FacesContext.getCurrentInstance();
        return CookieHelper.getCookie(name, (HttpServletRequest)context.getExternalContext().getRequest());
    }

    @Deprecated
    protected void initFromCookies() {
        try {
            String cookie = SessionBean.getCookie(LANGUAGE_COOKIE);
            this.setLanguage(cookie != null ? cookie : "Frisian");
            cookie = SessionBean.getCookie(THEME_COOKIE);
            this.setCurrentTheme(cookie != null ? cookie : "aristo");
        }
        catch (Exception e) {
            LOGGER.warn("problem setting language or theme", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLanguages() {
        Map<String, Locale> map = languageLocales;
        synchronized (map) {
            if (languageLocales.isEmpty()) {
                this.addLanguage("Dutch", "nl", "NL");
                this.addLanguage("English", "en", "EN");
                this.addLanguage("Frisian", "fy", "NL");
            }
        }
    }

    public List<String> getLanguages() {
        return languages;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (!languageLocales.containsKey(language)) {
            throw new IllegalArgumentException(language + " not supported");
        }
        this.locale = languageLocales.get(language);
        FacesContext.getCurrentInstance().getViewRoot().setLocale(this.locale);
        this.language = language;
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mayEdit(String role) {
        Map<String, Boolean> map = this.allowed;
        synchronized (map) {
            if (this.allowed.containsKey(role)) {
                return this.allowed.get(role);
            }
            this.allowed.put(role, this.securityContext.isCallerInRole(role));
        }
        return this.allowed.get(role);
    }

    public boolean mayEdit() {
        return this.mayEdit("editor");
    }

    public void languageChanged(ValueChangeEvent e) {
        this.setLanguage((String)e.getNewValue());
        SessionBean.setCookie(LANGUAGE_COOKIE, this.language);
    }

    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        Principal p = this.securityContext.getCallerPrincipal();
        this.user = p == null ? "not logged in" : p.getName();
        return this.user;
    }

    public void logout() {
        try {
            JsfUtil.logout();
            FacesContext.getCurrentInstance().getExternalContext().redirect(SessionBean.getLogoutPath());
        }
        catch (IOException | ServletException ex) {
            LoggerFactory.getLogger((String)SessionBean.class.getName()).error(null, ex);
        }
    }

    protected static String getLogoutPath() {
        return JsfUtil.contextPath() + "/login.xhtml";
    }
}

