/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.lazy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.security.enterprise.SecurityContext;
import org.fryske_akademy.Util;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.Param;
import org.fryske_akademy.jsf.AbstractLazyController;
import org.fryske_akademy.jsf.Filtering;
import org.fryske_akademy.services.CrudReadService;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public abstract class AbstractLazyModel<E extends EntityInterface>
extends LazyDataModel<E>
implements Filtering<E> {
    private final Class<E> clazz;
    private boolean useOr;
    private boolean syntaxInvalue = true;
    private boolean caseInsensitive = false;
    private AbstractLazyController abstractLazyController;
    private final Map<String, Object> filters = new HashMap<String, Object>(3){

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                this.put(String.valueOf(key), null);
            }
            return super.get(key);
        }
    };
    @Inject
    private transient SecurityContext securityContext;

    public AbstractLazyController getLazyController() {
        return this.abstractLazyController;
    }

    public final void setLazyController(AbstractLazyController lazyController) {
        if (this.abstractLazyController != null) {
            throw new IllegalStateException(String.format("replacing %s with %s not allowed", this.abstractLazyController, lazyController));
        }
        this.abstractLazyController = lazyController;
    }

    public AbstractLazyModel(Class<E> clazz) {
        this.clazz = clazz;
    }

    public abstract CrudReadService getCrudReadService();

    public E getRowData(String rowKey) {
        return (E)("".equals(rowKey) ? null : (EntityInterface)this.getCrudReadService().find((Serializable)Integer.valueOf(rowKey), this.clazz));
    }

    protected Param.Builder initParamBuilder() {
        return new Param.Builder(this.isSyntaxInvalue(), Param.Builder.DEFAULT_MAPPING, this.isCaseInsensitive());
    }

    protected List<Param> convertFilters(Map<String, Object> filters) {
        if (filters == null) {
            return null;
        }
        Param.Builder builder = this.initParamBuilder();
        for (Map.Entry<String, Object> p : filters.entrySet()) {
            if ("".equals(p.getValue()) || p.getValue() == null) continue;
            this.addToParamBuilder(builder, p.getKey(), p.getValue());
        }
        return builder.build();
    }

    protected abstract void addToParamBuilder(Param.Builder var1, String var2, Object var3);

    public final List<E> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        ArrayList<SortMeta> s = new ArrayList<SortMeta>(1);
        s.add(new SortMeta(null, sortField, sortOrder, null));
        return this.load(first, pageSize, s, filters);
    }

    public final List<E> load(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        CrudReadService.SORTORDER.Builder sortBuilder = this.convertSortMeta(multiSortMeta);
        List<Param> convertFilters = this.convertFilters(filters);
        List load = this.getCrudReadService().findDynamic(Integer.valueOf(first), Integer.valueOf(pageSize), sortBuilder.build(), convertFilters, this.clazz);
        this.setWrappedData(load);
        this.setRowCount(this.getCrudReadService().countDynamic(convertFilters, this.clazz));
        return load;
    }

    protected CrudReadService.SORTORDER.Builder convertSortMeta(List<SortMeta> multiSortMeta) {
        CrudReadService.SORTORDER.Builder sortBuilder = new CrudReadService.SORTORDER.Builder();
        if (multiSortMeta != null) {
            multiSortMeta.forEach(h -> sortBuilder.add(h.getSortField(), AbstractLazyModel.convert(h.getSortOrder())));
        }
        return sortBuilder;
    }

    public static CrudReadService.SORTORDER convert(SortOrder order) {
        if (order == null) {
            return null;
        }
        switch (order) {
            case ASCENDING: {
                return CrudReadService.SORTORDER.ASC;
            }
            case UNSORTED: {
                return CrudReadService.SORTORDER.NONE;
            }
        }
        return CrudReadService.SORTORDER.DESC;
    }

    @Override
    public final List<E> getFiltered() {
        return this.getWrappedData();
    }

    @Override
    public final void setFiltered(List<E> filtered) {
    }

    @Override
    public Map<String, Object> getFilters() {
        return this.filters;
    }

    @Override
    public Filtering<E> add(String key, Object value) {
        this.filters.put(key, value);
        return this;
    }

    @Override
    public Filtering<E> clear() {
        this.filters.clear();
        return this;
    }

    @Override
    public boolean hasFilter(String key) {
        return this.filters.containsKey(key) && this.filters.get(key) != null && !String.valueOf(this.filters.get(key)).isEmpty();
    }

    public void setSyntaxInvalue(boolean syntaxInvalue) {
        this.syntaxInvalue = syntaxInvalue;
    }

    public boolean isUseOr() {
        return this.useOr;
    }

    public void setUseOr(boolean useOr) {
        this.useOr = useOr;
    }

    public boolean isSyntaxInvalue() {
        return this.syntaxInvalue;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    protected void wrapStringInWildCards(Param.Builder builder, String key, Object value) {
        String s;
        Object o = value;
        if (value instanceof String && !Param.Builder.valueIsOperator((String)(s = (String)value), (boolean)builder.isSyntaxInValue())) {
            o = "*" + s + "*";
            if (s.indexOf(33) == 0) {
                o = "!" + o;
            }
        }
        builder.add(key, o, this.isUseOr());
    }

    public Object getRowKey(E object) {
        return object.getId() == null ? Integer.valueOf(-1) : object.getId();
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.securityContext = (SecurityContext)Util.getBean(SecurityContext.class, (Annotation[])new Annotation[0]);
    }

    protected SecurityContext getSecurityContext() {
        return this.securityContext;
    }
}

