/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.fryske_akademy.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsfUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JsfUtil.class.getName());
    private static final Map<Class, Converter> CLASS_CONVERTER_MAP = new HashMap<Class, Converter>();
    private static final ResourceBundle rootBundle = ResourceBundle.getBundle("EMPTY", Locale.ROOT);

    public static void handleException(Exception ex, String prefix) throws Exception {
        FacesContext.getCurrentInstance().validationFailed();
        Throwable t = Util.deepestCause((Throwable)ex);
        String msg = t instanceof ConstraintViolationException ? Util.formatConstraintException((ConstraintViolationException)((ConstraintViolationException)t)).toString() : t.getLocalizedMessage();
        JsfUtil.addErrorMessage(prefix + msg);
        throw ex;
    }

    public static boolean isValidationFailed() {
        return FacesContext.getCurrentInstance().isValidationFailed();
    }

    public static void addErrorMessage(Exception ex, String defaultMsg) {
        String msg = ex.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            JsfUtil.addErrorMessage(msg);
        } else {
            JsfUtil.addErrorMessage(defaultMsg);
        }
    }

    public static void addErrorMessages(List<String> messages) {
        for (String message : messages) {
            JsfUtil.addErrorMessage(message);
        }
    }

    public static void addErrorMessage(String msg) {
        String cid = null;
        JsfUtil.addErrorMessage(cid, msg);
    }

    public static void addErrorMessage(String clientId, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMsg);
    }

    public static void addSuccessMessage(String msg) {
        JsfUtil.addSuccessMessage("successInfo", msg);
    }

    public static void addSuccessMessage(String clientId, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMsg);
    }

    public static <T> T findInContext(Class<T> clazz) {
        return JsfUtil.findInContext(Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1), clazz);
    }

    public static <T> T findInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object obj = facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), null, (Object)name);
        return (T)obj;
    }

    public static <T> T findOrCreateInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().evaluateExpressionGet(facesContext, name, clazz);
    }

    public static Converter getConverter(Class clazz) {
        if (CLASS_CONVERTER_MAP.containsKey(clazz)) {
            return CLASS_CONVERTER_MAP.get(clazz);
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Converter converter = facesContext.getApplication().createConverter(clazz);
        if (converter == null) {
            LOGGER.warn(String.format("no converter found for %s", clazz));
        } else {
            CLASS_CONVERTER_MAP.put(clazz, converter);
        }
        return CLASS_CONVERTER_MAP.get(clazz);
    }

    public static String fullServletPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String contextPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath();
    }

    public static void redirectToServletPath(String servletPath) throws IOException {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        externalContext.redirect(externalContext.getRequestContextPath() + servletPath);
    }

    public static void logout() throws ServletException {
        FacesContext.getCurrentInstance().getExternalContext().invalidateSession();
        ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).logout();
    }

    public static ResourceBundle getLocaleBundle(String bundle) {
        FacesContext currentInstance = FacesContext.getCurrentInstance();
        Locale loc = currentInstance != null ? currentInstance.getViewRoot().getLocale() : Locale.getDefault();
        try {
            return ResourceBundle.getBundle(bundle, loc);
        }
        catch (MissingResourceException e) {
            LOGGER.warn("resource (properties file) not found: " + bundle + " for locale: " + loc + ", returning EMPTY");
            return rootBundle;
        }
    }

    public static String getFromBundle(ResourceBundle bundle, String key) {
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        LOGGER.warn(String.format("%s not found in language bundle %s", key, bundle));
        return key;
    }
}

