/*
 * Copyright 2018 Fryske Akademy.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fryske_akademy.jsf.exceptions;

/*-
 * #%L
 * primefacesgui
 * %%
 * Copyright (C) 2018 - 2021 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import jakarta.faces.context.ExceptionHandler;
import org.fryske_akademy.Util;
import org.primefaces.application.exceptionhandler.ExceptionInfo;
import org.primefaces.application.exceptionhandler.PrimeExceptionHandler;

import java.io.IOException;

/**
 * Uses {@link Util#deepestCause(java.lang.Throwable) } to build ExceptionInfo and log cause. NOTE you
 * may need the original stacktrace, you can set log level for {@link Util} to fine to see the original stacktrace.
 * Use {@link DeepestCauseExceptionHandlerFactory} as exception-handler-factory in faces-config.
 * 
 * @author eduard
 */
public class DeepestCauseExceptionHandler extends PrimeExceptionHandler {
    
    public DeepestCauseExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
    }

    @Override
    protected ExceptionInfo createExceptionInfo(Throwable rootCause) throws IOException {
        return super.createExceptionInfo(Util.deepestCause(rootCause));
    }

    @Override
    protected void logException(Throwable rootCause) {
        super.logException(Util.deepestCause(rootCause));
    }
    
    
    
}
