/*
 * Decompiled with CFR 0.152.
 */
package io.fury;

import com.google.common.base.Preconditions;
import io.fury.builder.JITContext;
import io.fury.config.CompatibleMode;
import io.fury.config.Config;
import io.fury.config.FuryBuilder;
import io.fury.config.Language;
import io.fury.config.LongEncoding;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.EnumStringResolver;
import io.fury.resolver.MapRefResolver;
import io.fury.resolver.NoRefResolver;
import io.fury.resolver.RefResolver;
import io.fury.resolver.SerializationContext;
import io.fury.serializer.ArraySerializers;
import io.fury.serializer.BufferCallback;
import io.fury.serializer.BufferObject;
import io.fury.serializer.OpaqueObjects;
import io.fury.serializer.PrimitiveSerializers;
import io.fury.serializer.Serializer;
import io.fury.serializer.SerializerFactory;
import io.fury.serializer.StringSerializer;
import io.fury.type.Generics;
import io.fury.type.Type;
import io.fury.util.ExceptionUtils;
import io.fury.util.LoggerFactory;
import io.fury.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public final class Fury {
    private static final Logger LOG = LoggerFactory.getLogger(Fury.class);
    public static final byte NULL_FLAG = -3;
    public static final byte REF_FLAG = -2;
    public static final byte NOT_NULL_VALUE_FLAG = -1;
    public static final byte REF_VALUE_FLAG = 0;
    public static final byte NOT_SUPPORT_CROSS_LANGUAGE = 0;
    public static final short FURY_TYPE_TAG_ID = Type.FURY_TYPE_TAG.getId();
    private static final byte isNilFlag = 1;
    private static final byte isLittleEndianFlag = 2;
    private static final byte isCrossLanguageFlag = 4;
    private static final byte isOutOfBandFlag = 8;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private final Config config;
    private final boolean refTracking;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final EnumStringResolver enumStringResolver;
    private final SerializationContext serializationContext;
    private final ClassLoader classLoader;
    private final JITContext jitContext;
    private final MemoryBuffer buffer;
    private final List<Object> nativeObjects;
    private final StringSerializer stringSerializer;
    private final Language language;
    private final boolean compressInt;
    private final LongEncoding longEncoding;
    private final Generics generics;
    private Language peerLanguage;
    private BufferCallback bufferCallback;
    private Iterator<MemoryBuffer> outOfBandBuffers;
    private boolean peerOutOfBandEnabled;
    private int depth;

    public Fury(FuryBuilder builder, ClassLoader classLoader) {
        this.config = new Config(builder);
        this.language = this.config.getLanguage();
        this.refTracking = this.config.trackingRef();
        this.compressInt = this.config.compressInt();
        this.longEncoding = this.config.longEncoding();
        this.refResolver = this.refTracking ? new MapRefResolver() : new NoRefResolver();
        this.jitContext = new JITContext(this);
        this.enumStringResolver = new EnumStringResolver();
        this.classResolver = new ClassResolver(this);
        this.classResolver.initialize();
        this.serializationContext = new SerializationContext();
        this.classLoader = classLoader;
        this.buffer = MemoryUtils.buffer(32);
        this.nativeObjects = new ArrayList<Object>();
        this.generics = new Generics(this);
        this.stringSerializer = new StringSerializer(this);
        LOG.info("Created new fury {}", (Object)this);
    }

    public void register(Class<?> cls) {
        this.classResolver.register(cls);
    }

    public void register(Class<?> cls, Short id) {
        this.classResolver.register(cls, id.shortValue());
    }

    public void register(Class<?> cls, String typeTag) {
        this.classResolver.register(cls, typeTag);
    }

    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this.classResolver.registerSerializer(type, serializerClass);
    }

    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        this.classResolver.registerSerializer(type, serializer);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.classResolver.setSerializerFactory(serializerFactory);
    }

    public SerializerFactory getSerializerFactory() {
        return this.classResolver.getSerializerFactory();
    }

    public MemoryBuffer serialize(Object obj, long address, int size) {
        MemoryBuffer buffer = MemoryUtils.buffer(address, size);
        this.serialize(buffer, obj, null);
        return buffer;
    }

    public byte[] serialize(Object obj) {
        this.buffer.writerIndex(0);
        this.serialize(this.buffer, obj, null);
        return this.buffer.getBytes(0, this.buffer.writerIndex());
    }

    public byte[] serialize(Object obj, BufferCallback callback) {
        this.buffer.writerIndex(0);
        this.serialize(this.buffer, obj, callback);
        return this.buffer.getBytes(0, this.buffer.writerIndex());
    }

    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.serialize(buffer, obj, null);
    }

    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj, BufferCallback callback) {
        this.bufferCallback = callback;
        int maskIndex = buffer.writerIndex();
        buffer.ensure(maskIndex + 1);
        buffer.writerIndex(maskIndex + 1);
        byte bitmap = 0;
        if (obj == null) {
            bitmap = (byte)(bitmap | 1);
            buffer.put(maskIndex, bitmap);
            return buffer;
        }
        if (isLittleEndian) {
            bitmap = (byte)(bitmap | 2);
        }
        if (this.language != Language.JAVA) {
            bitmap = (byte)(bitmap | 4);
            buffer.writeByte((byte)Language.JAVA.ordinal());
        }
        if (this.bufferCallback != null) {
            bitmap = (byte)(bitmap | 8);
        }
        buffer.put(maskIndex, bitmap);
        try {
            this.jitContext.lock();
            if (this.language == Language.JAVA) {
                this.write(buffer, obj);
            } else {
                this.xserializeInternal(buffer, obj);
            }
            MemoryBuffer memoryBuffer = buffer;
            return memoryBuffer;
        }
        catch (StackOverflowError t) {
            throw this.processStackOverflowError(t);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    public void serialize(OutputStream outputStream, Object obj) {
        this.serialize(outputStream, obj, null);
    }

    public void serialize(OutputStream outputStream, Object obj, BufferCallback callback) {
        this.buffer.writerIndex(0);
        this.buffer.writeInt(-1);
        this.serialize(this.buffer, obj, callback);
        this.buffer.putInt(0, this.buffer.writerIndex() - 4);
        try {
            outputStream.write(this.buffer.getBytes(0, this.buffer.writerIndex()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private StackOverflowError processStackOverflowError(StackOverflowError e) {
        if (!this.refTracking) {
            StackOverflowError t1;
            String msg = "Object may contain circular references, please enable ref tracking by `FuryBuilder#withRefTracking(true)`";
            String rawMessage = e.getMessage();
            if (StringUtils.isNotBlank(rawMessage)) {
                msg = msg + ": " + rawMessage;
            }
            if ((t1 = ExceptionUtils.trySetStackOverflowErrorMessage(e, msg)) != null) {
                return t1;
            }
        }
        throw e;
    }

    private void write(MemoryBuffer buffer, Object obj) {
        if (this.config.shareMetaContext()) {
            int startOffset = buffer.writerIndex();
            buffer.writeInt(-1);
            this.writeRef(buffer, obj);
            buffer.putInt(startOffset, buffer.writerIndex());
            this.classResolver.writeClassDefs(buffer);
        } else {
            this.writeRef(buffer, obj);
        }
    }

    private void xserializeInternal(MemoryBuffer buffer, Object obj) {
        int startOffset = buffer.writerIndex();
        buffer.writeInt(-1);
        buffer.writeInt(-1);
        this.xwriteRef(buffer, obj);
        buffer.putInt(startOffset, buffer.writerIndex());
        buffer.putInt(startOffset + 4, this.nativeObjects.size());
        this.refResolver.resetWrite();
        this.classResolver.resetWrite();
        this.enumStringResolver.resetWrite();
        for (Object nativeObject : this.nativeObjects) {
            this.writeRef(buffer, nativeObject);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
            this.classResolver.writeClass(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getClassInfo(obj.getClass(), classInfoHolder);
            this.classResolver.writeClass(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        Serializer<Object> serializer = classInfo.getSerializer();
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                this.classResolver.writeClass(buffer, classInfo);
                ++this.depth;
                serializer.write(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.classResolver.writeClass(buffer, classInfo);
            ++this.depth;
            serializer.write(buffer, obj);
            --this.depth;
        }
    }

    public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ++this.depth;
                serializer.write(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            ++this.depth;
            serializer.write(buffer, obj);
            --this.depth;
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj);
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj, this.classResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj, classInfo);
        }
    }

    public void writeNonRef(MemoryBuffer buffer, Object obj) {
        ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
        this.classResolver.writeClass(buffer, classInfo);
        this.writeData(buffer, classInfo, obj);
    }

    public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        this.classResolver.writeClass(buffer, classInfo);
        Serializer<Object> serializer = classInfo.getSerializer();
        ++this.depth;
        serializer.write(buffer, obj);
        --this.depth;
    }

    public <T> void writeNonRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        ++this.depth;
        serializer.write(buffer, obj);
        --this.depth;
    }

    public void xwriteRef(MemoryBuffer buffer, Object obj) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            this.xwriteNonRef(buffer, obj, null);
        }
    }

    public <T> void xwriteRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                this.xwriteNonRef(buffer, obj, serializer);
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.xwriteNonRef(buffer, obj, serializer);
        }
    }

    public <T> void xwriteRefByNullableSerializer(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer == null) {
            this.xwriteRef(buffer, obj);
        } else {
            this.xwriteRef(buffer, obj, serializer);
        }
    }

    public <T> void xwriteNonRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        ++this.depth;
        Class<?> cls = obj.getClass();
        if (serializer == null) {
            serializer = this.classResolver.getSerializer(cls);
        }
        short typeId = serializer.getXtypeId();
        buffer.writeShort(typeId);
        if (typeId != 0) {
            if (typeId == FURY_TYPE_TAG_ID) {
                this.classResolver.xwriteTypeTag(buffer, cls);
            }
            if (typeId < 0) {
                this.classResolver.xwriteClass(buffer, cls);
            }
            serializer.xwrite(buffer, obj);
        } else {
            this.classResolver.xwriteClass(buffer, cls);
            buffer.writePositiveVarInt(this.nativeObjects.size());
            this.nativeObjects.add(obj);
        }
        --this.depth;
    }

    private void writeData(MemoryBuffer buffer, ClassInfo classInfo, Object obj) {
        switch (classInfo.getClassId()) {
            case 14: {
                buffer.writeBoolean((Boolean)obj);
                break;
            }
            case 15: {
                buffer.writeByte((Byte)obj);
                break;
            }
            case 16: {
                buffer.writeChar(((Character)obj).charValue());
                break;
            }
            case 17: {
                buffer.writeShort((Short)obj);
                break;
            }
            case 18: {
                if (this.compressInt) {
                    buffer.writeVarInt((Integer)obj);
                    break;
                }
                buffer.writeInt((Integer)obj);
                break;
            }
            case 19: {
                buffer.writeFloat(((Float)obj).floatValue());
                break;
            }
            case 20: {
                PrimitiveSerializers.LongSerializer.writeLong(buffer, (Long)obj, this.longEncoding);
                break;
            }
            case 21: {
                buffer.writeDouble((Double)obj);
                break;
            }
            case 22: {
                this.stringSerializer.writeJavaString(buffer, (String)obj);
                break;
            }
            default: {
                ++this.depth;
                classInfo.getSerializer().write(buffer, obj);
                --this.depth;
            }
        }
    }

    public void writeBufferObject(MemoryBuffer buffer, BufferObject bufferObject) {
        if (this.bufferCallback == null || this.bufferCallback.apply(bufferObject)) {
            buffer.writeBoolean(true);
            int totalBytes = bufferObject.totalBytes();
            if (this.language == Language.JAVA) {
                buffer.writePositiveVarIntAligned(totalBytes);
            } else {
                buffer.writePositiveVarInt(totalBytes);
            }
            int writerIndex = buffer.writerIndex();
            buffer.ensure(writerIndex + bufferObject.totalBytes());
            bufferObject.writeTo(buffer);
            int size = buffer.writerIndex() - writerIndex;
            Preconditions.checkArgument((size == totalBytes ? 1 : 0) != 0);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void writeBufferObject(MemoryBuffer buffer, ArraySerializers.PrimitiveArrayBufferObject bufferObject) {
        if (this.bufferCallback == null || this.bufferCallback.apply(bufferObject)) {
            buffer.writeBoolean(true);
            int totalBytes = bufferObject.totalBytes();
            if (this.language == Language.JAVA) {
                buffer.writePositiveVarIntAligned(totalBytes);
            } else {
                buffer.writePositiveVarInt(totalBytes);
            }
            bufferObject.writeTo(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public MemoryBuffer readBufferObject(MemoryBuffer buffer) {
        boolean inBand = buffer.readBoolean();
        if (inBand) {
            int size = this.language == Language.JAVA ? buffer.readPositiveAlignedVarInt() : buffer.readPositiveVarInt();
            MemoryBuffer slice = buffer.slice(buffer.readerIndex(), size);
            buffer.readerIndex(buffer.readerIndex() + size);
            return slice;
        }
        Preconditions.checkArgument((boolean)this.outOfBandBuffers.hasNext());
        return this.outOfBandBuffers.next();
    }

    public void writeString(MemoryBuffer buffer, String str) {
        this.stringSerializer.writeString(buffer, str);
    }

    public String readString(MemoryBuffer buffer) {
        return this.stringSerializer.readString(buffer);
    }

    public void writeJavaStringRef(MemoryBuffer buffer, String str) {
        if (this.stringSerializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, str)) {
                this.stringSerializer.writeJavaString(buffer, str);
            }
        } else if (str == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.stringSerializer.write(buffer, str);
        }
    }

    public String readJavaStringRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        if (this.stringSerializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                String obj = this.stringSerializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return (String)refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.stringSerializer.read(buffer);
    }

    public void writeJavaString(MemoryBuffer buffer, String str) {
        this.stringSerializer.writeJavaString(buffer, str);
    }

    public String readJavaString(MemoryBuffer buffer) {
        return this.stringSerializer.readJavaString(buffer);
    }

    public void writeLong(MemoryBuffer buffer, long value) {
        PrimitiveSerializers.LongSerializer.writeLong(buffer, value, this.longEncoding);
    }

    public long readLong(MemoryBuffer buffer) {
        return PrimitiveSerializers.LongSerializer.readLong(buffer, this.longEncoding);
    }

    public Object deserialize(byte[] bytes) {
        return this.deserialize(MemoryUtils.wrap(bytes), null);
    }

    public Object deserialize(byte[] bytes, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.deserialize(MemoryUtils.wrap(bytes), outOfBandBuffers);
    }

    public Object deserialize(long address, int size) {
        return this.deserialize(MemoryUtils.buffer(address, size), null);
    }

    public Object deserialize(MemoryBuffer buffer) {
        return this.deserialize(buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(MemoryBuffer buffer, Iterable<MemoryBuffer> outOfBandBuffers) {
        try {
            Object obj;
            this.jitContext.lock();
            byte bitmap = buffer.readByte();
            if ((bitmap & 1) == 1) {
                Object var4_4 = null;
                return var4_4;
            }
            boolean isLittleEndian = (bitmap & 2) == 2;
            Preconditions.checkArgument((boolean)Fury.isLittleEndian, (Object)isLittleEndian);
            boolean isTargetXLang = (bitmap & 4) == 4;
            this.peerLanguage = isTargetXLang ? Language.values()[buffer.readByte()] : Language.JAVA;
            boolean bl = this.peerOutOfBandEnabled = (bitmap & 8) == 8;
            if (this.peerOutOfBandEnabled) {
                Preconditions.checkNotNull(outOfBandBuffers, (Object)"outOfBandBuffers shouldn't be null when the serialized stream is produced with bufferCallback not null.");
                this.outOfBandBuffers = outOfBandBuffers.iterator();
            } else {
                Preconditions.checkArgument((outOfBandBuffers == null ? 1 : 0) != 0, (Object)"outOfBandBuffers should be null when the serialized stream is produced with bufferCallback null.");
            }
            if (isTargetXLang) {
                obj = this.xdeserializeInternal(buffer);
            } else {
                if (this.config.shareMetaContext()) {
                    this.classResolver.readClassDefs(buffer);
                }
                obj = this.readRef(buffer);
            }
            Object object = obj;
            return object;
        }
        finally {
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    public Object deserialize(InputStream inputStream) {
        return this.deserialize(inputStream, null);
    }

    public Object deserialize(InputStream inputStream, Iterable<MemoryBuffer> outOfBandBuffers) {
        try {
            Fury.readToBufferFromStream(inputStream, this.buffer);
            return this.deserialize(this.buffer, outOfBandBuffers);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object xdeserializeInternal(MemoryBuffer buffer) {
        int nativeObjectsStartOffset = buffer.readInt();
        int nativeObjectsSize = buffer.readInt();
        int endReaderIndex = nativeObjectsStartOffset;
        if (this.peerLanguage == Language.JAVA) {
            int readerIndex = buffer.readerIndex();
            buffer.readerIndex(nativeObjectsStartOffset);
            for (int i = 0; i < nativeObjectsSize; ++i) {
                this.nativeObjects.add(this.readRef(buffer));
            }
            endReaderIndex = buffer.readerIndex();
            buffer.readerIndex(readerIndex);
            this.refResolver.resetRead();
            this.classResolver.resetRead();
            this.enumStringResolver.resetRead();
        }
        Object obj = this.xreadRef(buffer);
        buffer.readerIndex(endReaderIndex);
        return obj;
    }

    public Object readRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer, classInfoHolder));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            int nextReadRefId = this.refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                T obj = serializer.read(buffer);
                this.refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return (T)this.refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return serializer.read(buffer);
    }

    public Object readNonRef(MemoryBuffer buffer) {
        return this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer));
    }

    public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        return this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer, classInfoHolder));
    }

    public Object readNullable(MemoryBuffer buffer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.readNonRef(buffer);
    }

    public Object readData(MemoryBuffer buffer, ClassInfo classInfo) {
        ++this.depth;
        Serializer serializer = classInfo.getSerializer();
        Object read = serializer.read(buffer);
        --this.depth;
        return read;
    }

    private Object readDataInternal(MemoryBuffer buffer, ClassInfo classInfo) {
        switch (classInfo.getClassId()) {
            case 14: {
                return buffer.readBoolean();
            }
            case 15: {
                return buffer.readByte();
            }
            case 16: {
                return Character.valueOf(buffer.readChar());
            }
            case 17: {
                return buffer.readShort();
            }
            case 18: {
                if (this.compressInt) {
                    return buffer.readVarInt();
                }
                return buffer.readInt();
            }
            case 19: {
                return Float.valueOf(buffer.readFloat());
            }
            case 20: {
                return PrimitiveSerializers.LongSerializer.readLong(buffer, this.longEncoding);
            }
            case 21: {
                return buffer.readDouble();
            }
            case 22: {
                return this.stringSerializer.readJavaString(buffer);
            }
        }
        ++this.depth;
        Object read = classInfo.getSerializer().read(buffer);
        --this.depth;
        return read;
    }

    public Object xreadRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.xreadNonRef(buffer, null);
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public Object xreadRef(MemoryBuffer buffer, Serializer<?> serializer) {
        if (serializer.needToWriteRef()) {
            RefResolver refResolver = this.refResolver;
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.xreadNonRef(buffer, serializer);
                refResolver.setReadObject(nextReadRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.xreadNonRef(buffer, serializer);
    }

    public Object xreadRefByNullableSerializer(MemoryBuffer buffer, Serializer<?> serializer) {
        if (serializer == null) {
            return this.xreadRef(buffer);
        }
        return this.xreadRef(buffer, serializer);
    }

    public Object xreadNonRef(MemoryBuffer buffer, Serializer<?> serializer) {
        ++this.depth;
        short typeId = buffer.readShort();
        ClassResolver classResolver = this.classResolver;
        if (typeId != 0) {
            Class<?> cls = null;
            if (typeId == FURY_TYPE_TAG_ID) {
                cls = classResolver.readClassByTypeTag(buffer);
            }
            if (typeId < 0) {
                if (this.peerLanguage != Language.JAVA) {
                    classResolver.xreadClassName(buffer);
                    cls = classResolver.getClassByTypeId(-typeId);
                } else {
                    cls = classResolver.xreadClass(buffer);
                }
            } else if (typeId != FURY_TYPE_TAG_ID) {
                cls = classResolver.getClassByTypeId(typeId);
            }
            Preconditions.checkNotNull(cls);
            if (serializer == null) {
                serializer = classResolver.getSerializer(cls);
            }
            Object o = serializer.xread(buffer);
            --this.depth;
            return o;
        }
        String className = classResolver.xreadClassName(buffer);
        int ordinal = buffer.readPositiveVarInt();
        if (this.peerLanguage != Language.JAVA) {
            return OpaqueObjects.of(this.peerLanguage, className, ordinal);
        }
        return this.nativeObjects.get(ordinal);
    }

    public byte[] serializeJavaObject(Object obj) {
        this.buffer.writerIndex(0);
        this.serializeJavaObject(this.buffer, obj);
        return this.buffer.getBytes(0, this.buffer.writerIndex());
    }

    public void serializeJavaObject(MemoryBuffer buffer, Object obj) {
        try {
            this.jitContext.lock();
            if (this.config.shareMetaContext()) {
                int startOffset = buffer.writerIndex();
                buffer.writeInt(-1);
                if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                    ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
                    this.writeData(buffer, classInfo, obj);
                }
                buffer.putInt(startOffset, buffer.writerIndex());
                this.classResolver.writeClassDefs(buffer);
            } else if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
                this.writeData(buffer, classInfo, obj);
            }
        }
        catch (StackOverflowError t) {
            throw this.processStackOverflowError(t);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    public void serializeJavaObject(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serializeJavaObject((MemoryBuffer)buf, obj));
    }

    public <T> T deserializeJavaObject(byte[] data, Class<T> cls) {
        return this.deserializeJavaObject(MemoryBuffer.fromByteArray(data), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserializeJavaObject(MemoryBuffer buffer, Class<T> cls) {
        try {
            int nextReadRefId;
            if (this.config.shareMetaContext()) {
                this.classResolver.readClassDefs(buffer);
            }
            if ((nextReadRefId = this.refResolver.tryPreserveRefId(buffer)) >= -1) {
                Object obj;
                Object object = obj = this.readDataInternal(buffer, this.classResolver.getClassInfo(cls));
                return (T)object;
            }
            T t = null;
            return t;
        }
        finally {
            this.resetRead();
        }
    }

    public <T> T deserializeJavaObject(InputStream inputStream, Class<T> cls) {
        return (T)this.deserializeFromStream(inputStream, buf -> this.deserializeJavaObject((MemoryBuffer)buf, cls));
    }

    public byte[] serializeJavaObjectAndClass(Object obj) {
        this.buffer.writerIndex(0);
        this.serializeJavaObjectAndClass(this.buffer, obj);
        return this.buffer.getBytes(0, this.buffer.writerIndex());
    }

    public void serializeJavaObjectAndClass(MemoryBuffer buffer, Object obj) {
        try {
            this.jitContext.lock();
            this.write(buffer, obj);
        }
        catch (StackOverflowError t) {
            throw this.processStackOverflowError(t);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    public void serializeJavaObjectAndClass(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serializeJavaObjectAndClass((MemoryBuffer)buf, obj));
    }

    public Object deserializeJavaObjectAndClass(byte[] data) {
        return this.deserializeJavaObjectAndClass(MemoryBuffer.fromByteArray(data));
    }

    public Object deserializeJavaObjectAndClass(MemoryBuffer buffer) {
        try {
            this.jitContext.lock();
            if (this.config.shareMetaContext()) {
                this.classResolver.readClassDefs(buffer);
            }
            Object object = this.readRef(buffer);
            return object;
        }
        finally {
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    public Object deserializeJavaObjectAndClass(InputStream inputStream) {
        return this.deserializeFromStream(inputStream, this::deserializeJavaObjectAndClass);
    }

    private void serializeToStream(OutputStream outputStream, Consumer<MemoryBuffer> function) {
        if (outputStream.getClass() == ByteArrayOutputStream.class) {
            byte[] oldBytes = this.buffer.getHeapMemory();
            MemoryUtils.wrap((ByteArrayOutputStream)outputStream, this.buffer);
            int writerIndex = this.buffer.writerIndex();
            this.buffer.writeInt(-1);
            function.accept(this.buffer);
            this.buffer.putInt(writerIndex, this.buffer.writerIndex() - writerIndex);
            MemoryUtils.wrap(this.buffer, (ByteArrayOutputStream)outputStream);
            this.buffer.pointTo(oldBytes, 0, oldBytes.length);
        } else {
            this.buffer.writerIndex(0);
            this.buffer.writeInt(-1);
            function.accept(this.buffer);
            this.buffer.putInt(0, this.buffer.writerIndex() - 4);
            try {
                byte[] bytes = this.buffer.getHeapMemory();
                if (bytes != null) {
                    outputStream.write(bytes, 0, this.buffer.writerIndex());
                } else {
                    outputStream.write(this.buffer.getBytes(0, this.buffer.writerIndex()));
                }
                outputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Object deserializeFromStream(InputStream inputStream, Function<MemoryBuffer, Object> function) {
        try {
            boolean isBis = inputStream.getClass() == ByteArrayInputStream.class;
            byte[] oldBytes = null;
            if (isBis) {
                this.buffer.readerIndex(0);
                oldBytes = this.buffer.getHeapMemory();
                MemoryUtils.wrap((ByteArrayInputStream)inputStream, this.buffer);
                this.buffer.increaseReaderIndex(4);
            } else {
                Fury.readToBufferFromStream(inputStream, this.buffer);
            }
            Object o = function.apply(this.buffer);
            if (isBis) {
                inputStream.skip(this.buffer.readerIndex());
                this.buffer.pointTo(oldBytes, 0, oldBytes.length);
            }
            return o;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void readToBufferFromStream(InputStream inputStream, MemoryBuffer buffer) throws IOException {
        int count;
        buffer.readerIndex(0);
        int read = inputStream.read(buffer.getHeapMemory(), 0, 4);
        Preconditions.checkArgument((read == 4 ? 1 : 0) != 0);
        int size = buffer.readInt();
        buffer.ensure(4 + size);
        for (read = 0; read < size && (count = inputStream.read(buffer.getHeapMemory(), read + 4, size - read)) != -1; read += count) {
        }
        Preconditions.checkArgument((read == size ? 1 : 0) != 0);
    }

    public void reset() {
        this.refResolver.reset();
        this.classResolver.reset();
        this.enumStringResolver.reset();
        this.serializationContext.reset();
        this.nativeObjects.clear();
        this.peerOutOfBandEnabled = false;
        this.bufferCallback = null;
        this.depth = 0;
    }

    public void resetWrite() {
        this.refResolver.resetWrite();
        this.classResolver.resetWrite();
        this.enumStringResolver.resetWrite();
        this.serializationContext.reset();
        this.nativeObjects.clear();
        this.bufferCallback = null;
        this.depth = 0;
    }

    public void resetRead() {
        this.refResolver.resetRead();
        this.classResolver.resetRead();
        this.enumStringResolver.resetRead();
        this.serializationContext.reset();
        this.nativeObjects.clear();
        this.peerOutOfBandEnabled = false;
        this.depth = 0;
    }

    public JITContext getJITContext() {
        return this.jitContext;
    }

    public BufferCallback getBufferCallback() {
        return this.bufferCallback;
    }

    public boolean isPeerOutOfBandEnabled() {
        return this.peerOutOfBandEnabled;
    }

    public RefResolver getRefResolver() {
        return this.refResolver;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public EnumStringResolver getEnumStringResolver() {
        return this.enumStringResolver;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public Generics getGenerics() {
        return this.generics;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void incDepth(int diff) {
        this.depth += diff;
    }

    public StringSerializer getStringSerializer() {
        return this.stringSerializer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean trackingRef() {
        return this.refTracking;
    }

    public boolean isStringRefIgnored() {
        return this.config.isStringRefIgnored();
    }

    public boolean isBasicTypesRefIgnored() {
        return this.config.isBasicTypesRefIgnored();
    }

    public boolean checkClassVersion() {
        return this.config.checkClassVersion();
    }

    public CompatibleMode getCompatibleMode() {
        return this.config.getCompatibleMode();
    }

    public Config getConfig() {
        return this.config;
    }

    public Class<? extends Serializer> getDefaultJDKStreamSerializerType() {
        return this.config.getDefaultJDKStreamSerializerType();
    }

    public boolean compressString() {
        return this.config.compressString();
    }

    public boolean compressInt() {
        return this.compressInt;
    }

    public LongEncoding longEncoding() {
        return this.longEncoding;
    }

    public boolean compressLong() {
        return this.config.compressLong();
    }

    public static FuryBuilder builder() {
        return new FuryBuilder();
    }
}

