/*
 * Decompiled with CFR 0.152.
 */
package io.fury.codegen;

import com.google.common.base.Preconditions;
import io.fury.util.LoggerFactory;
import io.fury.util.StringUtils;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class CompileUnit {
    private static final Logger LOG = LoggerFactory.getLogger(CompileUnit.class);
    String pkg;
    String mainClassName;
    private String code;
    private Supplier<String> genCodeFunc;

    public CompileUnit(String pkg, String mainClassName, String code) {
        this.pkg = pkg;
        this.mainClassName = mainClassName;
        this.code = code;
    }

    public CompileUnit(String pkg, String mainClassName, Supplier<String> genCodeFunc) {
        this.pkg = pkg;
        this.mainClassName = mainClassName;
        this.genCodeFunc = genCodeFunc;
    }

    public String getCode() {
        if (this.code == null) {
            Preconditions.checkNotNull(this.genCodeFunc);
            long startTime = System.nanoTime();
            this.code = this.genCodeFunc.get();
            long durationMs = (System.nanoTime() - startTime) / 1000000L;
            LOG.info("Generate code for {} took {} ms.", (Object)this.getQualifiedClassName(), (Object)durationMs);
        }
        return this.code;
    }

    public String getQualifiedClassName() {
        if (StringUtils.isNotBlank(this.pkg)) {
            return this.pkg + "." + this.mainClassName;
        }
        return this.mainClassName;
    }

    public String toString() {
        return "CompileUnit{pkg='" + this.pkg + '\'' + ", mainClassName='" + this.mainClassName + '\'' + '}';
    }
}

