/*
 * Decompiled with CFR 0.152.
 */
package io.fury.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import io.fury.collection.MapEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LazyMap<K, V>
extends ForwardingMap<K, V> {
    private List<Map.Entry<K, V>> entries;
    private Map<K, V> map;

    public LazyMap() {
        this.entries = new ArrayList<Map.Entry<K, V>>();
    }

    public LazyMap(int size) {
        this.entries = new ArrayList<Map.Entry<K, V>>(size);
    }

    public LazyMap(List<Map.Entry<K, V>> entries) {
        this.entries = entries;
    }

    public Map<K, V> delegate() {
        if (this.map == null) {
            this.map = new HashMap(this.entries.size());
            for (Map.Entry<K, V> entry : this.entries) {
                this.map.put(entry.getKey(), entry.getValue());
            }
        }
        return this.map;
    }

    public V put(K key, V value) {
        if (this.map == null) {
            this.entries.add(new MapEntry<K, V>(key, value));
            return null;
        }
        return this.map.put(key, value);
    }

    public void setEntries(List<Map.Entry<K, V>> entries) {
        Preconditions.checkArgument((this.map == null ? 1 : 0) != 0);
        this.entries = entries;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entries.iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

