/*
 * Decompiled with CFR 0.152.
 */
package io.fury.resolver;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.exception.ClassNotCompatibleException;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.PrimitiveSerializers;
import io.fury.type.Descriptor;
import io.fury.type.TypeUtils;
import io.fury.util.FieldAccessor;
import io.fury.util.MurmurHash3;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class FieldResolver {
    public static final short MAX_EMBED_CLASS_ID = 127;
    private static final Object STUB = new Object();
    private static final Field STUB_FIELD;
    public static final byte EMBED_CLASS_TYPE_FLAG = 1;
    public static final byte EMBED_TYPES_4_FLAG = 1;
    public static final byte EMBED_TYPES_9_FLAG = 3;
    public static final byte EMBED_TYPES_HASH_FLAG = 7;
    public static final byte SEPARATE_TYPES_HASH_FLAG = 0;
    public static final byte OBJECT_END_FLAG = 2;
    private static final long END_TAG = 0x7FFFFFFFFFFFFFFEL;
    private final Class<?> cls;
    private final Fury fury;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final ClassInfoHolder classInfoHolder;
    private final int numFields;
    private final Set<String> duplicatedFields;
    private final FieldInfo[] embedTypes4Fields;
    private final FieldInfo[] embedTypes9Fields;
    private final FieldInfo[] embedTypesHashFields;
    private final FieldInfo[] separateTypesHashFields;
    private final short minPrimitiveClassId;
    private final short maxPrimitiveClassId;
    private final PrimitiveSerializers.IntSerializer intSerializer;
    private final PrimitiveSerializers.LongSerializer longSerializer;

    public static FieldResolver of(Fury fury, Class<?> cls) {
        return FieldResolver.of(fury, cls, true, false);
    }

    public static FieldResolver of(Fury fury, Class<?> type, boolean resolveParent, boolean ignoreCollectionType) {
        SortedMap<Field, Descriptor> allFieldsMap = fury.getClassResolver().getAllDescriptorsMap(type, resolveParent);
        Set<String> duplicatedFields = resolveParent ? Descriptor.getSortedDuplicatedFields(type).keySet() : new HashSet<String>();
        List<ClassField> allFields = allFieldsMap.keySet().stream().map(ClassField::new).collect(Collectors.toList());
        return new FieldResolver(fury, type, ignoreCollectionType, allFields, duplicatedFields);
    }

    public FieldResolver(Fury fury, Class<?> type, boolean ignoreCollectionType, List<ClassField> allFields, Set<String> duplicatedFields) {
        this.cls = type;
        this.fury = fury;
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.duplicatedFields = duplicatedFields;
        this.numFields = allFields.size();
        this.minPrimitiveClassId = this.classResolver.getRegisteredClassId(TypeUtils.getSortedPrimitiveClasses().get(0));
        this.maxPrimitiveClassId = this.classResolver.getRegisteredClassId(TypeUtils.getSortedPrimitiveClasses().get(8));
        this.intSerializer = (PrimitiveSerializers.IntSerializer)this.classResolver.getSerializer(Integer.TYPE);
        this.longSerializer = (PrimitiveSerializers.LongSerializer)this.classResolver.getSerializer(Long.TYPE);
        this.classInfoHolder = this.classResolver.nilClassInfoHolder();
        Comparator<FieldInfo> fieldInfoComparator = Comparator.comparingLong(FieldInfo::getEncodedFieldInfo);
        TreeSet<FieldInfo> embedTypes4FieldsSet = new TreeSet<FieldInfo>(fieldInfoComparator);
        TreeSet<FieldInfo> embedTypes9FieldsSet = new TreeSet<FieldInfo>(fieldInfoComparator);
        TreeSet<FieldInfo> embedTypesHashFieldsSet = new TreeSet<FieldInfo>(fieldInfoComparator);
        TreeSet<FieldInfo> separateTypesHashFieldsSet = new TreeSet<FieldInfo>(fieldInfoComparator);
        Preconditions.checkState((this.maxPrimitiveClassId < 127 ? 1 : 0) != 0);
        for (ClassField classField : allFields) {
            FieldInfo fieldInfo;
            String fieldName = classField.getName();
            Class<?> fieldType = classField.getType();
            if (duplicatedFields.contains(fieldName)) {
                fieldName = classField.getDeclaringClass().getName() + "#" + fieldName;
            }
            int fieldNameLen = FieldResolver.encodingBytesLength(fieldName);
            Short classId = this.classResolver.getRegisteredClassId(fieldType);
            if (ReflectionUtils.isFinal(fieldType) && classId != null && classId < 127) {
                if (fieldNameLen <= 3 && classId <= 63) {
                    int encodedFieldInfo = (int)FieldResolver.encodeFieldNameAsLong(fieldName);
                    encodedFieldInfo = encodedFieldInfo << 8 | classId.byteValue() << 2 | 1;
                    FieldInfo fieldInfo2 = new FieldInfo(fury, fieldName, fieldType, classField.getField(), 0, FieldInfoEncodingType.EMBED_TYPES_4, encodedFieldInfo, classId);
                    embedTypes4FieldsSet.add(fieldInfo2);
                    continue;
                }
                if (fieldNameLen <= 7) {
                    long encodedFieldInfo = FieldResolver.encodeFieldNameAsLong(fieldName);
                    encodedFieldInfo = encodedFieldInfo << 10 | (long)(classId << 3) | 3L;
                    fieldInfo = new FieldInfo(fury, fieldName, fieldType, classField.getField(), 0, FieldInfoEncodingType.EMBED_TYPES_9, encodedFieldInfo, classId);
                    embedTypes9FieldsSet.add(fieldInfo);
                    continue;
                }
                long encodedFieldInfo = FieldResolver.computeStringHash(fieldName);
                encodedFieldInfo = encodedFieldInfo << 10 | (long)(classId << 3) | 7L;
                fieldInfo = new FieldInfo(fury, fieldName, fieldType, classField.getField(), 0, FieldInfoEncodingType.EMBED_TYPES_HASH, encodedFieldInfo, classId);
                embedTypesHashFieldsSet.add(fieldInfo);
                continue;
            }
            long encodedFieldInfo = FieldResolver.computeStringHash(fieldName) << 2;
            fieldInfo = FieldInfo.of(fury, fieldName, fieldType, classField.getField(), FieldInfoEncodingType.SEPARATE_TYPES_HASH, encodedFieldInfo, ignoreCollectionType);
            separateTypesHashFieldsSet.add(fieldInfo);
        }
        this.embedTypes4Fields = embedTypes4FieldsSet.toArray(new FieldInfo[0]);
        this.embedTypes9Fields = embedTypes9FieldsSet.toArray(new FieldInfo[0]);
        this.embedTypesHashFields = embedTypesHashFieldsSet.toArray(new FieldInfo[0]);
        this.separateTypesHashFields = separateTypesHashFieldsSet.toArray(new FieldInfo[0]);
        Preconditions.checkArgument((this.embedTypes4Fields.length + this.embedTypes9Fields.length + this.embedTypesHashFields.length + this.separateTypesHashFields.length == allFields.size() ? 1 : 0) != 0);
    }

    public boolean hasDuplicatedFields() {
        return !this.duplicatedFields.isEmpty();
    }

    static long encodeFieldNameAsLong(String fieldName) {
        long fieldNameEncoded = 0L;
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (c >= '0' && c <= '9') {
                fieldNameEncoded = fieldNameEncoded << 6 | (long)(c - 48 & 0x3F);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                fieldNameEncoded = fieldNameEncoded << 6 | (long)(c - 65 + 10 & 0x3F);
                continue;
            }
            Preconditions.checkArgument((c >= 'a' && c <= 'z' ? 1 : 0) != 0, (String)"%s should b in range a~z", (char)c);
            fieldNameEncoded = fieldNameEncoded << 6 | (long)(c - 97 + 10 + 26 & 0x3F);
        }
        return fieldNameEncoded;
    }

    static String decodeLongAsString(long encodedStr, int numBits) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < numBits; i += 6) {
            byte x = (byte)(encodedStr & 0x3FL);
            if (x < 10) {
                stringBuilder.append((char)(48 + x));
            } else if (x < 36) {
                stringBuilder.append((char)(65 + x - 10));
            } else {
                Preconditions.checkArgument((x < 62 ? 1 : 0) != 0);
                stringBuilder.append((char)(97 + x - 10 - 26));
            }
            encodedStr >>>= 6;
        }
        return stringBuilder.reverse().toString();
    }

    static int encodingBytesLength(String fieldName) {
        Preconditions.checkArgument((fieldName.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (c < '0') {
                return 8;
            }
            if (c > '9' && c < 'A') {
                return 8;
            }
            if (c > 'Z' && c < 'a') {
                return 8;
            }
            if (c <= 'z') continue;
            return 8;
        }
        return (int)Math.ceil((double)fieldName.length() * 6.0 / 8.0);
    }

    static long computeStringHash(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        return MurmurHash3.murmurhash3_x64_128(bytes, 0, bytes.length, 47)[0];
    }

    public long skipDataBy4(MemoryBuffer buffer, int partFieldInfo) {
        if ((partFieldInfo & 1) == 1) {
            byte classId;
            if ((partFieldInfo & 3) == 1) {
                classId = (byte)((partFieldInfo & 0xFF) >> 2);
            } else {
                classId = (byte)((partFieldInfo & 0x3FF) >>> 3);
                buffer.increaseReaderIndexUnsafe(4);
            }
            ClassInfo classInfo = this.classResolver.getClassInfo(classId);
            if (classId >= this.minPrimitiveClassId && classId <= this.maxPrimitiveClassId) {
                this.fury.readData(buffer, classInfo);
            } else {
                this.fury.readRef(buffer, classInfo.getSerializer());
            }
        } else {
            long encodedFieldInfo = buffer.readInt();
            if (((encodedFieldInfo = encodedFieldInfo << 32 | (long)partFieldInfo & 0xFFFFFFFFL) & 3L) == 0L) {
                this.skipObjectField(buffer);
            } else {
                if (encodedFieldInfo != 0x7FFFFFFFFFFFFFFEL) {
                    throw new ClassNotCompatibleException(String.format("Class %s end tag should be %d but got %d, maybe peer has different duplicate fields in class hierarchy", this.cls, 0x7FFFFFFFFFFFFFFEL, encodedFieldInfo));
                }
                return 0x7FFFFFFFFFFFFFFEL;
            }
        }
        return partFieldInfo;
    }

    public long skipDataBy8(MemoryBuffer buffer, long partFieldInfo) {
        if ((partFieldInfo & 1L) == 1L) {
            byte classId;
            if ((partFieldInfo & 3L) == 1L) {
                classId = (byte)((partFieldInfo & 0xFFL) >> 2);
                buffer.increaseReaderIndexUnsafe(-4);
            } else {
                classId = (byte)((partFieldInfo & 0x3FFL) >>> 3);
            }
            ClassInfo classInfo = this.classResolver.getClassInfo(classId);
            if (classId >= this.minPrimitiveClassId && classId <= this.maxPrimitiveClassId) {
                if (classId == 9) {
                    this.intSerializer.read(buffer);
                } else if (classId == 11) {
                    this.longSerializer.read(buffer);
                } else {
                    this.fury.readData(buffer, classInfo);
                }
            } else {
                this.fury.readRef(buffer, classInfo.getSerializer());
            }
        } else if ((partFieldInfo & 3L) == 0L) {
            this.skipObjectField(buffer);
        } else {
            if (partFieldInfo != 0x7FFFFFFFFFFFFFFEL) {
                throw new ClassNotCompatibleException(String.format("Class %s end tag should be %d but got %d, maybe peer has different duplicate fields in class hierarchy", this.cls, 0x7FFFFFFFFFFFFFFEL, partFieldInfo));
            }
            return 0x7FFFFFFFFFFFFFFEL;
        }
        return partFieldInfo;
    }

    public void skipObjectField(MemoryBuffer buffer) {
        int nextReadRefId = this.refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o;
            byte fieldType = buffer.readByte();
            if (fieldType == 0) {
                ClassInfo classInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
                o = this.fury.readData(buffer, classInfo);
            } else {
                o = this.readObjectWithFinal(buffer, fieldType);
            }
            this.refResolver.setReadObject(nextReadRefId, o);
        }
    }

    public void skipEndFields(MemoryBuffer buffer, long partFieldInfo) {
        long endTag = this.getEndTag();
        while (partFieldInfo < endTag) {
            if (this.skipDataBy8(buffer, partFieldInfo) != partFieldInfo) {
                return;
            }
            partFieldInfo = buffer.readLong();
        }
        if (partFieldInfo != endTag) {
            throw new IllegalStateException(String.format("Object should end with %d but got %d.", endTag, partFieldInfo));
        }
    }

    public void checkFieldType(byte fieldType, byte expectType) {
        if (fieldType != expectType) {
            throw new IllegalArgumentException(String.format("Expect byte type %d but got %d.", expectType, fieldType));
        }
    }

    public Object readObjectField(MemoryBuffer buffer, FieldInfo fieldInfo) {
        int nextReadRefId = this.refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            byte fieldType = buffer.readByte();
            this.checkFieldType(fieldType, fieldInfo.fieldType);
            Object o = fieldType == 0 ? this.fury.readData(buffer, this.classResolver.readClassInfo(buffer, fieldInfo.getClassInfoHolder())) : this.readObjectWithFinal(buffer, fieldType, fieldInfo);
            this.refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return this.refResolver.getReadObject();
    }

    private Object readObjectWithFinal(MemoryBuffer buffer, byte fieldType) {
        Object o;
        if (fieldType == 1) {
            ClassInfo elementClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            CollectionSerializers.CollectionSerializer collectionSerializer = (CollectionSerializers.CollectionSerializer)classInfo.getSerializer();
            collectionSerializer.setElementSerializer(elementClassInfo.getSerializer());
            o = collectionSerializer.read(buffer);
        } else if (fieldType == 4) {
            ClassInfo keyClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo valueClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
            mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
            mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
            o = mapSerializer.read(buffer);
        } else if (fieldType == 2) {
            ClassInfo keyClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
            mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
            o = mapSerializer.read(buffer);
        } else {
            Preconditions.checkArgument((fieldType == 3 ? 1 : 0) != 0);
            ClassInfo valueClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
            mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
            o = mapSerializer.read(buffer);
        }
        return o;
    }

    private Object readObjectWithFinal(MemoryBuffer buffer, byte fieldType, FieldInfo fieldInfo) {
        Object o;
        if (fieldType == 1) {
            ClassInfo elementClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, fieldInfo.getClassInfoHolder());
            CollectionSerializers.CollectionSerializer collectionSerializer = (CollectionSerializers.CollectionSerializer)classInfo.getSerializer();
            collectionSerializer.setElementSerializer(elementClassInfo.getSerializer());
            o = collectionSerializer.read(buffer);
        } else if (fieldType == 4) {
            ClassInfo keyClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo valueClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, fieldInfo.getClassInfoHolder());
            MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
            mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
            mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
            o = mapSerializer.read(buffer);
        } else if (fieldType == 2) {
            ClassInfo keyClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, fieldInfo.getClassInfoHolder());
            MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
            mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
            o = mapSerializer.read(buffer);
        } else {
            Preconditions.checkArgument((fieldType == 3 ? 1 : 0) != 0);
            ClassInfo valueClassInfo = this.classResolver.readClassInfo(buffer, this.classInfoHolder);
            ClassInfo classInfo = this.classResolver.readClassInfo(buffer, fieldInfo.getClassInfoHolder());
            MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
            mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
            o = mapSerializer.read(buffer);
        }
        return o;
    }

    public long getEndTag() {
        return 0x7FFFFFFFFFFFFFFEL;
    }

    public FieldInfo[] getEmbedTypes4Fields() {
        return this.embedTypes4Fields;
    }

    public FieldInfo[] getEmbedTypes9Fields() {
        return this.embedTypes9Fields;
    }

    public FieldInfo[] getEmbedTypesHashFields() {
        return this.embedTypesHashFields;
    }

    public FieldInfo[] getSeparateTypesHashFields() {
        return this.separateTypesHashFields;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public List<FieldInfo> getAllFieldsList() {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        Collections.addAll(fieldInfoList, this.embedTypes4Fields);
        Collections.addAll(fieldInfoList, this.embedTypes9Fields);
        Collections.addAll(fieldInfoList, this.embedTypesHashFields);
        Collections.addAll(fieldInfoList, this.separateTypesHashFields);
        return fieldInfoList;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\nclass: " + this.cls + ", classLoader: " + this.cls.getClassLoader() + ",\nembedTypes4Fields: " + Arrays.toString(this.embedTypes4Fields) + ",\nembedTypes9Fields: " + Arrays.toString(this.embedTypes9Fields) + ",\nembedTypesHashFields: " + Arrays.toString(this.embedTypesHashFields) + ",\nseparateTypesHashFields: " + Arrays.toString(this.separateTypesHashFields) + "\n" + '}';
    }

    static {
        try {
            STUB_FIELD = FieldResolver.class.getDeclaredField("STUB");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MapFieldInfo
    extends FieldInfo {
        private final Class<?> keyType;
        private final boolean isKeyTypeFinal;
        private final TypeToken<?> keyTypeToken;
        private final TypeToken<?> valueTypeToken;
        private final ClassInfoHolder keyClassInfoHolder;
        private final Class<?> valueType;
        private final boolean isValueTypeFinal;
        private final ClassInfoHolder valueClassInfoHolder;

        public MapFieldInfo(Fury fury, Field field, byte fieldType, FieldInfoEncodingType separateTypesHash, long encodedFieldInfo, TypeToken<?> keyTypeToken, TypeToken<?> valueTypeToken) {
            super(fury, field.getName(), field.getType(), field, fieldType, separateTypesHash, encodedFieldInfo, (short)0);
            Preconditions.checkArgument((field != STUB_FIELD ? 1 : 0) != 0);
            this.keyTypeToken = keyTypeToken;
            this.valueTypeToken = valueTypeToken;
            this.keyType = TypeUtils.getRawType(keyTypeToken);
            this.isKeyTypeFinal = Modifier.isFinal(this.keyType.getModifiers());
            this.keyClassInfoHolder = this.classResolver.nilClassInfoHolder();
            this.valueType = TypeUtils.getRawType(valueTypeToken);
            this.isValueTypeFinal = Modifier.isFinal(this.valueType.getModifiers());
            this.valueClassInfoHolder = this.classResolver.nilClassInfoHolder();
        }

        public boolean isKeyTypeFinal() {
            return this.isKeyTypeFinal;
        }

        public boolean isValueTypeFinal() {
            return this.isValueTypeFinal;
        }

        public ClassInfo getKeyClassInfo() {
            return this.getKeyClassInfo(this.keyType);
        }

        public ClassInfo getKeyClassInfo(Class<?> keyType) {
            return this.classResolver.getClassInfo(keyType, this.keyClassInfoHolder);
        }

        public ClassInfo getValueClassInfo() {
            return this.getValueClassInfo(this.valueType);
        }

        public ClassInfo getValueClassInfo(Class<?> valueType) {
            return this.classResolver.getClassInfo(valueType, this.valueClassInfoHolder);
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }
    }

    public static class CollectionFieldInfo
    extends FieldInfo {
        private final TypeToken<?> elementTypeToken;
        private final Class<?> elementType;
        private final ClassInfoHolder elementClassInfoHolder;

        public CollectionFieldInfo(Fury fury, Field field, byte fieldType, FieldInfoEncodingType fieldInfoEncodingType, long encodedFieldInfo, TypeToken<?> elementTypeToken) {
            super(fury, field.getName(), field.getType(), field, fieldType, fieldInfoEncodingType, encodedFieldInfo, (short)0);
            Preconditions.checkArgument((field != STUB_FIELD ? 1 : 0) != 0);
            this.elementTypeToken = elementTypeToken;
            this.elementType = TypeUtils.getRawType(elementTypeToken);
            this.elementClassInfoHolder = this.classResolver.nilClassInfoHolder();
        }

        public ClassInfo getElementClassInfo() {
            return this.getElementClassInfo(this.elementType);
        }

        public ClassInfo getElementClassInfo(Class<?> elementType) {
            return this.classResolver.getClassInfo(elementType, this.elementClassInfoHolder);
        }

        public TypeToken<?> getElementTypeToken() {
            return this.elementTypeToken;
        }

        public Class<?> getElementType() {
            return this.elementType;
        }
    }

    public static class FieldInfo {
        private final String name;
        private final Class<?> type;
        private final Field field;
        private final byte fieldType;
        private final FieldInfoEncodingType fieldInfoEncodingType;
        private final short classId;
        private final long encodedFieldInfo;
        protected final ClassResolver classResolver;
        private final FieldAccessor fieldAccessor;
        private final ClassInfoHolder classInfoHolder;

        public FieldInfo(Fury fury, String name, Class<?> type, Field field, byte fieldType, FieldInfoEncodingType fieldInfoEncodingType, long encodedFieldInfo, short classId) {
            this.name = name;
            this.type = type;
            this.field = field;
            this.fieldType = fieldType;
            this.fieldInfoEncodingType = fieldInfoEncodingType;
            this.encodedFieldInfo = encodedFieldInfo;
            this.classId = classId;
            this.classResolver = fury.getClassResolver();
            this.classInfoHolder = this.classResolver.nilClassInfoHolder();
            this.fieldAccessor = field == null || field == STUB_FIELD ? null : FieldAccessor.createAccessor(field);
        }

        public static FieldInfo of(Fury fury, String fieldName, Class<?> fieldTypeClass, Field field, FieldInfoEncodingType fieldInfoEncodingType, long encodedFieldInfo, boolean ignoreCollectionType) {
            if (ignoreCollectionType) {
                return new FieldInfo(fury, fieldName, fieldTypeClass, field, 0, fieldInfoEncodingType, encodedFieldInfo, 0);
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                TypeToken<?> elementTypeToken = TypeUtils.getElementType(TypeToken.of((Type)field.getGenericType()));
                byte fieldType = Modifier.isFinal(TypeUtils.getRawType(elementTypeToken).getModifiers()) ? (byte)1 : 0;
                return new CollectionFieldInfo(fury, field, fieldType, fieldInfoEncodingType, encodedFieldInfo, elementTypeToken);
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                Tuple2<TypeToken<?>, TypeToken<?>> kvType = TypeUtils.getMapKeyValueType(TypeToken.of((Type)field.getGenericType()));
                TypeToken keyTypeToken = (TypeToken)kvType.f0;
                TypeToken valueTypeToken = (TypeToken)kvType.f1;
                byte fieldType = Modifier.isFinal(TypeUtils.getRawType(keyTypeToken).getModifiers()) && Modifier.isFinal(TypeUtils.getRawType(valueTypeToken).getModifiers()) ? (byte)4 : (Modifier.isFinal(TypeUtils.getRawType(keyTypeToken).getModifiers()) ? (byte)2 : (Modifier.isFinal(TypeUtils.getRawType(valueTypeToken).getModifiers()) ? (byte)3 : 0));
                return new MapFieldInfo(fury, field, fieldType, fieldInfoEncodingType, encodedFieldInfo, keyTypeToken, valueTypeToken);
            }
            return new FieldInfo(fury, fieldName, fieldTypeClass, field, 0, fieldInfoEncodingType, encodedFieldInfo, 0);
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Field getField() {
            return this.field;
        }

        public byte getFieldType() {
            return this.fieldType;
        }

        public FieldInfoEncodingType getFieldInfoEncodingType() {
            return this.fieldInfoEncodingType;
        }

        public long getEncodedFieldInfo() {
            return this.encodedFieldInfo;
        }

        public FieldAccessor getFieldAccessor() {
            return this.fieldAccessor;
        }

        public ClassInfoHolder getClassInfoHolder() {
            return this.classInfoHolder;
        }

        public ClassInfo getClassInfo(Class<?> cls) {
            return this.classResolver.getClassInfo(cls, this.classInfoHolder);
        }

        public ClassInfo getClassInfo(short classId) {
            ClassInfo classInfo = this.classInfoHolder.classInfo;
            if (classInfo.classId == 0) {
                Preconditions.checkArgument((classId != 0 ? 1 : 0) != 0);
                this.classInfoHolder.classInfo = classInfo = this.classResolver.getClassInfo(classId);
            }
            return classInfo;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{name=" + this.name + ", type=" + this.type + ", encodedFieldInfo=" + this.encodedFieldInfo + '}';
        }

        public short getEmbeddedClassId() {
            return this.classId;
        }
    }

    public static class ClassField {
        private final String name;
        private final Class<?> type;
        private final Class<?> declaringClass;
        private final Field field;

        public ClassField(Field field) {
            this(field, field.getName(), field.getType(), field.getDeclaringClass());
        }

        public ClassField(String name, Class<?> type, Class<?> declaringClass) {
            this(STUB_FIELD, name, type, declaringClass);
        }

        public ClassField(Field field, String name, Class<?> type, Class<?> declaringClass) {
            this.name = name;
            this.type = type;
            this.declaringClass = declaringClass;
            this.field = field;
        }

        String getName() {
            return this.name;
        }

        Class<?> getType() {
            return this.type;
        }

        Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public Field getField() {
            return this.field;
        }
    }

    public static enum FieldInfoEncodingType {
        EMBED_TYPES_4,
        EMBED_TYPES_9,
        EMBED_TYPES_HASH,
        SEPARATE_TYPES_HASH;

    }

    public static class FieldTypes {
        public static final byte OBJECT = 0;
        public static final byte COLLECTION_ELEMENT_FINAL = 1;
        public static final byte MAP_KEY_FINAL = 2;
        public static final byte MAP_VALUE_FINAL = 3;
        public static final byte MAP_KV_FINAL = 4;
    }
}

