/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.collection.IdentityObjectIntMap;
import io.fury.collection.LazyMap;
import io.fury.collection.LongMap;
import io.fury.collection.MapEntry;
import io.fury.collection.Tuple2;
import io.fury.collection.Tuple3;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.MetaContext;
import io.fury.resolver.RefResolver;
import io.fury.serializer.MetaSharedSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.type.ClassDef;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.Generics;
import java.util.ArrayList;
import java.util.Collection;

public final class UnexistedClassSerializers {

    public static final class UnexistedClassSerializer
    extends Serializer {
        private final ClassDef classDef;
        private final ClassInfoHolder classInfoHolder;
        private final LongMap<ClassFieldsInfo> fieldsInfoMap;

        public UnexistedClassSerializer(Fury fury, ClassDef classDef) {
            super(fury, UnexistedMetaSharedClass.class);
            this.classDef = classDef;
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
            this.fieldsInfoMap = new LongMap();
            Preconditions.checkArgument((boolean)fury.getConfig().shareMetaContext());
        }

        private void writeClassDef(MemoryBuffer buffer, UnexistedMetaSharedClass value) {
            buffer.increaseWriterIndex(-2);
            buffer.writeByte((byte)1);
            MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
            IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
            int newId = classMap.size;
            int id = classMap.putOrGet((Class<?>)value.classDef.getId(), newId);
            if (id >= 0) {
                buffer.writePositiveVarInt(id);
            } else {
                buffer.writePositiveVarInt(newId);
                metaContext.writingClassDefs.add(value.classDef);
            }
        }

        public void write(MemoryBuffer buffer, Object v) {
            UnexistedMetaSharedClass value = (UnexistedMetaSharedClass)v;
            this.writeClassDef(buffer, value);
            ClassDef classDef = value.classDef;
            ClassFieldsInfo fieldsInfo = this.getClassFieldsInfo(classDef);
            Fury fury = this.fury;
            RefResolver refResolver = fury.getRefResolver();
            ClassResolver classResolver = fury.getClassResolver();
            if (fury.checkClassVersion()) {
                buffer.writeInt(fieldsInfo.classVersionHash);
            }
            ObjectSerializer.FinalTypeField[] finalFields = fieldsInfo.finalFields;
            boolean[] isFinal = fieldsInfo.isFinal;
            for (int i = 0; i < finalFields.length; ++i) {
                ObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                ClassInfo classInfo = fieldInfo.classInfo;
                if (classResolver.isPrimitive(fieldInfo.classId)) {
                    classInfo.getSerializer().write(buffer, fieldValue);
                    continue;
                }
                if (isFinal[i]) {
                    Serializer serializer = classInfo.getSerializer();
                    fury.writeRef(buffer, fieldValue, serializer);
                    continue;
                }
                fury.writeRef(buffer, fieldValue, classInfo);
            }
            for (ObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.otherFields) {
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                if (fieldInfo.trackingRef) {
                    fury.writeRef(buffer, fieldValue, fieldInfo.classInfoHolder);
                    continue;
                }
                fury.writeNullable(buffer, fieldValue, fieldInfo.classInfoHolder);
            }
            Generics generics = fury.getGenerics();
            for (ObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.containerFields) {
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                ObjectSerializer.writeContainerFieldValue(fury, refResolver, classResolver, generics, fieldInfo, buffer, fieldValue);
            }
        }

        private ClassFieldsInfo getClassFieldsInfo(ClassDef classDef) {
            ClassFieldsInfo fieldsInfo = this.fieldsInfoMap.get(classDef.getId());
            if (fieldsInfo == null) {
                Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(this.fury.getClassResolver(), UnexistedSkipClass.class, classDef);
                DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(descriptors, true, this.fury.compressInt(), this.fury.compressLong());
                Tuple3<Tuple2<ObjectSerializer.FinalTypeField[], boolean[]>, ObjectSerializer.GenericTypeField[], ObjectSerializer.GenericTypeField[]> tuple = ObjectSerializer.buildFieldInfos(this.fury, descriptorGrouper);
                int classVersionHash = 0;
                if (this.fury.checkClassVersion()) {
                    classVersionHash = ObjectSerializer.computeVersionHash(descriptors);
                }
                fieldsInfo = new ClassFieldsInfo((ObjectSerializer.FinalTypeField[])((Tuple2)tuple.f0).f0, (boolean[])((Tuple2)tuple.f0).f1, (ObjectSerializer.GenericTypeField[])tuple.f1, (ObjectSerializer.GenericTypeField[])tuple.f2, classVersionHash);
                this.fieldsInfoMap.put(classDef.getId(), fieldsInfo);
            }
            return fieldsInfo;
        }

        public Object read(MemoryBuffer buffer) {
            UnexistedMetaSharedClass obj = new UnexistedMetaSharedClass(this.classDef);
            Fury fury = this.fury;
            RefResolver refResolver = fury.getRefResolver();
            ClassResolver classResolver = fury.getClassResolver();
            refResolver.reference(obj);
            ArrayList entries = new ArrayList();
            ClassFieldsInfo fieldsInfo = this.getClassFieldsInfo(this.classDef);
            ObjectSerializer.FinalTypeField[] finalFields = fieldsInfo.finalFields;
            boolean[] isFinal = fieldsInfo.isFinal;
            for (int i = 0; i < finalFields.length; ++i) {
                ObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
                Object fieldValue = fieldInfo.classInfo == null ? fury.readRef(buffer, this.classInfoHolder) : (classResolver.isPrimitive(fieldInfo.classId) ? fieldInfo.classInfo.getSerializer().read(buffer) : ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal[i], buffer));
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            for (ObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.otherFields) {
                Object fieldValue = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            Generics generics = fury.getGenerics();
            for (ObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.containerFields) {
                Object fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            obj.setEntries(entries);
            return obj;
        }
    }

    private static final class ClassFieldsInfo {
        private final ObjectSerializer.FinalTypeField[] finalFields;
        private final boolean[] isFinal;
        private final ObjectSerializer.GenericTypeField[] otherFields;
        private final ObjectSerializer.GenericTypeField[] containerFields;
        private final int classVersionHash;

        private ClassFieldsInfo(ObjectSerializer.FinalTypeField[] finalFields, boolean[] isFinal, ObjectSerializer.GenericTypeField[] otherFields, ObjectSerializer.GenericTypeField[] containerFields, int classVersionHash) {
            this.finalFields = finalFields;
            this.isFinal = isFinal;
            this.otherFields = otherFields;
            this.containerFields = containerFields;
            this.classVersionHash = classVersionHash;
        }
    }

    public static class UnexistedMetaSharedClass
    extends LazyMap
    implements UnexistedClass {
        private final ClassDef classDef;

        public UnexistedMetaSharedClass(ClassDef classDef) {
            this.classDef = classDef;
        }
    }

    public static class UnexistedSkipClass
    implements UnexistedClass {
    }

    public static interface UnexistedClass {
    }
}

