/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.auditlog.component;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Format;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.genesys.blocks.auditlog.annotations.Audited;
import org.genesys.blocks.auditlog.annotations.HideAuditValue;
import org.genesys.blocks.auditlog.annotations.NotAudited;
import org.genesys.blocks.auditlog.model.AuditAction;
import org.genesys.blocks.auditlog.model.TransactionAuditLog;
import org.genesys.blocks.auditlog.service.AuditTrailService;
import org.genesys.blocks.model.BasicModel;
import org.genesys.blocks.model.EntityId;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class AuditTrailInterceptor
extends EmptyInterceptor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AuditTrailInterceptor.class);
    private static final long serialVersionUID = 1881637304461659508L;
    private static final Set<String> DEFAULT_IGNORED_PROPERTIES = Stream.of("serialVersionUID", "id", "createdDate", "lastModifiedDate", "version", "lastModifiedBy").collect(Collectors.toSet());
    private Set<String> ignoredProperties = new HashSet<String>(DEFAULT_IGNORED_PROPERTIES);
    private final Map<Class<?>, Set<String>> ignoredClassFields;
    private final Map<Class<?>, Set<String>> securedClassFields;
    private Set<Class<?>> auditedClasses = new HashSet();
    private final Set<Class<?>> ignoredClasses;
    private final Set<Class<?>> includedClasses;
    @Autowired
    private transient AuditTrailService auditTrailService;
    @PersistenceContext
    private transient EntityManager entityManager;
    private static final String dateFormat = "dd-MMM-yyyy";
    private static final String timeFormat = "HH:mm:ss";
    private static final String dateTimeFormat = "dd-MMM-yyyy HH:mm:ss";
    private static final Format dateFormatter = FastDateFormat.getInstance((String)"dd-MMM-yyyy");
    private static final Format dateTimeFormatter = FastDateFormat.getInstance((String)"dd-MMM-yyyy HH:mm:ss");
    private static final Format timeFormatter = FastDateFormat.getInstance((String)"HH:mm:ss");
    private static final ThreadLocal<Stack<Set<TransactionAuditLog>>> auditLogStack = new ThreadLocal<Stack<Set<TransactionAuditLog>>>(){

        @Override
        protected Stack<Set<TransactionAuditLog>> initialValue() {
            return new Stack<Set<TransactionAuditLog>>();
        }
    };

    public AuditTrailInterceptor() {
        log.info("Enabling {}", (Object)((Object)((Object)this)).getClass().getName());
        this.ignoredClasses = Collections.synchronizedSet(new HashSet());
        this.includedClasses = Collections.synchronizedSet(new HashSet());
        this.ignoredClassFields = Collections.synchronizedMap(new HashMap());
        this.securedClassFields = Collections.synchronizedMap(new HashMap());
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.ignoredProperties != null);
        assert (this.auditTrailService != null);
        this.ignoredProperties = Collections.unmodifiableSet(this.ignoredProperties);
        this.auditedClasses = Collections.unmodifiableSet(this.auditedClasses);
    }

    public void setAuditedClasses(Set<Class<?>> auditedClasses) {
        this.auditedClasses = auditedClasses;
    }

    public Set<Class<?>> getAuditedClasses() {
        return this.auditedClasses;
    }

    public void setIgnoredProperties(Set<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    public Set<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public void setAuditTrailService(AuditTrailService auditTrailService) {
        this.auditTrailService = auditTrailService;
    }

    public AuditTrailService getAuditTrailService() {
        return this.auditTrailService;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        Class<?> entityClass = entity.getClass();
        log.trace("Inspecting Entity.class={} id={}", entityClass, (Object)id);
        if (!this.isAudited(entityClass)) {
            return false;
        }
        Set<String> entityIgnoredFields = this.ignoredClassFields.get(entityClass);
        for (int i = 0; i < previousState.length; ++i) {
            String propertyName = propertyNames[i];
            Object prev = previousState[i];
            Object curr = currentState[i];
            if (this.ignoredProperties.contains(propertyName) || entityIgnoredFields != null && entityIgnoredFields.contains(propertyName)) {
                log.trace("{} property in {} is not audited.", (Object)propertyName, (Object)entityClass.getSimpleName());
                continue;
            }
            if ((prev == null || prev.equals(curr)) && (prev != null || curr == null)) continue;
            log.trace("prop={} prev={} curr={} type={}", new Object[]{propertyName, prev, curr, types[i].getReturnedClass()});
            if (this.isPrimitiveType(types[i].getReturnedClass())) {
                String currentValue = this.formatValue(curr, types[i], entityClass, propertyName);
                String previousValue = this.formatValue(prev, types[i], entityClass, propertyName);
                this.recordChange(entity, (Long)id, propertyName, previousValue, currentValue, null, prev, curr);
                continue;
            }
            if (this.isEntity(types[i].getReturnedClass())) {
                String currentValue;
                EntityId prevEntity = (EntityId)prev;
                EntityId currEntity = (EntityId)curr;
                String previousValue = prevEntity == null ? null : prevEntity.getId().toString();
                String string = currentValue = currEntity == null ? null : currEntity.getId().toString();
                if (StringUtils.equals((CharSequence)previousValue, (CharSequence)currentValue)) continue;
                this.recordChange(entity, (Long)id, propertyName, previousValue, currentValue, types[i].getReturnedClass(), prev, curr);
                continue;
            }
            log.trace("Entity.{} {} is not a primitive. Ignoring value={}", new Object[]{propertyName, prev == null ? null : prev.getClass(), prev});
        }
        return false;
    }

    private String formatValue(Object someValue, Type type, Class<?> entityClass, String propertyName) {
        if (someValue == null) {
            return null;
        }
        Set<String> securedFields = this.securedClassFields.get(entityClass);
        if (securedFields != null && securedFields.contains(propertyName)) {
            return "__FIELD_VALUE_NOT_AUDITED__";
        }
        Class returnedClass = type.getReturnedClass();
        if (Instant.class.equals((Object)returnedClass)) {
            return DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.systemDefault()).format((Instant)someValue);
        }
        if (LocalDate.class.equals((Object)returnedClass)) {
            return DateTimeFormatter.ISO_DATE.format((LocalDate)someValue);
        }
        if (Date.class.equals((Object)returnedClass) || Calendar.class.equals((Object)returnedClass)) {
            TemporalType temporalType = TemporalType.TIMESTAMP;
            try {
                Field field = entityClass.getDeclaredField(propertyName);
                if (field != null && field.isAnnotationPresent(Temporal.class)) {
                    Temporal ta = field.getAnnotation(Temporal.class);
                    temporalType = ta.value();
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                log.trace("Could not access field {}#{}", entityClass, (Object)propertyName);
            }
            switch (temporalType) {
                case TIMESTAMP: {
                    return dateTimeFormatter.format(someValue);
                }
                case DATE: {
                    return dateFormatter.format(someValue);
                }
                case TIME: {
                    return timeFormatter.format(someValue);
                }
            }
        }
        return someValue.toString();
    }

    private boolean isEntity(Class<?> clazz) {
        if (EntityId.class.isAssignableFrom(clazz)) {
            return true;
        }
        log.trace("{} is not an EntityId", (Object)clazz.getName());
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] states, String[] propertyNames, Type[] types) {
        Class<?> entityClass = entity.getClass();
        log.trace("Inspecting Entity.class={} id={}", entityClass, (Object)id);
        if (!this.isAudited(entityClass)) {
            log.trace("{} is not audited", entityClass);
            return;
        }
        Set<String> entityIgnoredFields = this.ignoredClassFields.get(entityClass);
        for (int i = 0; i < states.length; ++i) {
            String propertyName = propertyNames[i];
            Object state = states[i];
            if (this.ignoredProperties.contains(propertyName) || entityIgnoredFields != null && entityIgnoredFields.contains(propertyName) || state == null) continue;
            log.trace("Deleted prop={} state={} type={}", new Object[]{propertyName, state, types[i].getReturnedClass()});
            if (this.isPrimitiveType(types[i].getReturnedClass())) {
                this.recordDelete(entity, (Long)id, propertyName, state.toString(), null, null);
                continue;
            }
            if (this.isEntity(types[i].getReturnedClass())) {
                EntityId prevEntity = (EntityId)state;
                String previousValue = prevEntity.getId().toString();
                this.recordDelete(entity, (Long)id, propertyName, previousValue, types[i].getReturnedClass(), state);
                continue;
            }
            log.trace("Entity.{} {} is not a primitive. Ignoring value={}", new Object[]{propertyName, state.getClass(), state});
        }
    }

    public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
        log.trace("Collection recreated: key={} coll={}", (Object)key, collection);
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        PersistentCollection pc = (PersistentCollection)collection;
        if (!this.isAudited(pc.getOwner().getClass())) {
            log.trace("Class {} is not audited", pc.getOwner().getClass());
            return;
        }
        Class<?> ownerClass = pc.getOwner().getClass();
        String propertyName = pc.getRole().substring(pc.getRole().lastIndexOf(46) + 1);
        Class<?> propertyType = this.findPropertyType(ownerClass, propertyName);
        log.trace("Property class: {}.{}={}", new Object[]{ownerClass.getName(), propertyName, propertyType});
        Collection<Object> deleted = new HashSet();
        if (pc.getValue() == null) {
            log.trace("onCollectionRemove is empty, no change key={}", (Object)key);
            return;
        }
        if (pc.getValue() instanceof Collection) {
            deleted.addAll((Collection)pc.getValue());
        }
        if (deleted.isEmpty()) {
            log.trace("onCollectionRemove is empty, no change key={}", (Object)key);
            return;
        }
        Serializable snap = pc.getStoredSnapshot();
        log.trace("Collection remove: key={} coll={} snap={}", new Object[]{key, collection, snap});
        Class<?> referencedEntity = null;
        if (EntityId.class.isAssignableFrom(propertyType)) {
            log.trace("{} is EntityId, converting values.", (Object)propertyType.getName());
            referencedEntity = propertyType;
            deleted = this.convertEntityId(deleted);
        }
        log.trace("prev={} curr=null", deleted);
        this.recordDelete(pc.getOwner(), (Long)key, propertyName, deleted.toString(), referencedEntity, deleted);
    }

    public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
        PersistentCollection pc = (PersistentCollection)collection;
        if (!this.isAudited(pc.getOwner().getClass())) {
            log.trace("Class {} is not audited", pc.getOwner().getClass());
            return;
        }
        log.trace("Collection update: key={} coll={}", (Object)key, collection);
        Class<?> ownerClass = pc.getOwner().getClass();
        log.trace("ownerClass={} role={}", (Object)ownerClass.getName(), (Object)pc.getRole());
        String propertyName = pc.getRole().substring(pc.getRole().lastIndexOf(46) + 1);
        Class<?> propertyType = this.findPropertyType(ownerClass, propertyName);
        log.trace("Property class: {}.{}={}", new Object[]{ownerClass.getName(), propertyName, propertyType});
        Collection<Object> remaining = null;
        if (pc.getValue() instanceof Collection) {
            remaining = (Collection<Object>)pc.getValue();
        } else {
            log.trace("Can't handle pc={} val={}", pc.getValue().getClass(), (Object)pc);
        }
        Collection<Object> previous = null;
        Serializable snap = pc.getStoredSnapshot();
        if (snap instanceof Map) {
            Map snapMap = (Map)((Object)snap);
            previous = snapMap.keySet();
        } else if (snap instanceof Collection) {
            Collection snapList = (Collection)((Object)snap);
            previous = snapList;
        } else if (snap != null) {
            log.trace("Can't handle snap={} val={}", snap.getClass(), (Object)snap);
        }
        Class<?> referencedEntity = null;
        if (EntityId.class.isAssignableFrom(propertyType)) {
            log.trace("{} is EntityId, converting values.", (Object)propertyType.getName());
            referencedEntity = propertyType;
            previous = this.convertEntityId(previous);
            remaining = this.convertEntityId(remaining);
        }
        log.trace("prev={} curr={}", previous, (Object)remaining);
        try {
            this.recordChange(pc.getOwner(), (Long)key, propertyName, this.collectionToStringSorted(previous), this.collectionToStringSorted(remaining), referencedEntity, previous, remaining);
        }
        catch (ClassCastException e) {
            if (previous != null) {
                log.error("Previous {}: {}", previous.getClass(), previous);
            }
            if (remaining != null) {
                log.error("Remaining {}: {}", remaining.getClass(), remaining);
            }
            log.error("Could not serialize property {}#{}: {}", new Object[]{pc.getOwner().getClass(), propertyName, e.getMessage()});
        }
    }

    private String collectionToStringSorted(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection instanceof Set) {
            log.trace("Converting to sorted list {} -> {}", collection, (Object)collection.stream().sorted().map(Object::toString).collect(Collectors.joining(", ", "[", "]")));
            return collection.stream().sorted().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        }
        log.trace("Not sorting {}: {}", collection.getClass(), collection);
        return collection.toString();
    }

    private Class<?> findPropertyType(Class<? extends Object> class1, String propertyName) {
        log.trace("Finding property type for {}.{}", (Object)class1.getName(), (Object)propertyName);
        Field field = ReflectionUtils.findField(class1, (String)propertyName);
        if (field != null) {
            log.trace("Found field: {}\n\ttype={}\n\tgeneric={}\n\tgenericTN={}", new Object[]{field, field.getType(), field.getGenericType(), field.getGenericType().getTypeName()});
            ResolvableType t = ResolvableType.forField((Field)field, class1);
            if (t.hasGenerics()) {
                log.trace("\tResoved={} returning={}", (Object)t, (Object)t.resolveGeneric(new int[]{0}));
                return t.resolveGeneric(new int[]{0});
            }
            log.trace("Returning class itself={}", (Object)t.getRawClass());
            return t.getRawClass();
        }
        try {
            Method method = class1.getMethod("get" + StringUtils.capitalize((String)propertyName), new Class[0]);
            if (method != null) {
                log.trace("Didn't find field, found the method: {}", method.getReturnType().getTypeParameters()[0]);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            log.debug("Could not access getter: {}", (Object)e.getMessage());
        }
        return null;
    }

    private Collection<Object> convertEntityId(Collection<?> previous) {
        if (previous == null || previous.isEmpty()) {
            return List.of();
        }
        ArrayList<Object> converted = new ArrayList<Object>();
        for (Object p : previous) {
            if (p instanceof EntityId) {
                converted.add(((EntityId)p).getId());
                continue;
            }
            converted.add(p);
        }
        converted.sort((a, b) -> {
            if (a instanceof Long && b instanceof Long) {
                return Long.compare((Long)a, (Long)b);
            }
            if (a == null || b == null) {
                return 0;
            }
            return Integer.compare(a.hashCode(), b.hashCode());
        });
        return converted;
    }

    boolean isPrimitiveType(Class<?> class1) {
        if (class1.isPrimitive()) {
            return true;
        }
        if (class1.isEnum()) {
            return true;
        }
        if (class1.isArray()) {
            return false;
        }
        if (Number.class.isAssignableFrom(class1)) {
            return true;
        }
        if (String.class.equals(class1)) {
            return true;
        }
        if (Character.class.equals(class1)) {
            return true;
        }
        if (Boolean.class.equals(class1)) {
            return true;
        }
        if (Instant.class.equals(class1)) {
            return true;
        }
        if (LocalDate.class.equals(class1)) {
            return true;
        }
        if (UUID.class.equals(class1)) {
            return true;
        }
        log.trace("Class {} is not a primitive.", class1);
        return false;
    }

    private void recordChange(Object entity, Long id, String propertyName, String previousState, String currentState, Class<?> referencedEntity, Object prev, Object curr) {
        if (StringUtils.equals((CharSequence)previousState, (CharSequence)currentState) && !StringUtils.equals((CharSequence)currentState, (CharSequence)"__FIELD_VALUE_NOT_AUDITED__")) {
            log.trace("No state change {}.{} {}=={}", new Object[]{entity.getClass(), id, previousState, currentState});
            return;
        }
        TransactionAuditLog change = this.auditTrailService.auditLogEntry(AuditAction.UPDATE, entity, id, propertyName, previousState, currentState, referencedEntity, prev, curr);
        if (auditLogStack.get().peek().remove(change)) {
            log.trace("Replacing existing changelog {}", (Object)change);
        } else {
            log.trace("Adding new changelog {}", (Object)change);
        }
        auditLogStack.get().peek().add(change);
    }

    private void recordDelete(Object entity, Long id, String propertyName, String state, Class<?> referencedEntity, Object prev) {
        String stateToLog = state;
        if (stateToLog != null) {
            Set<String> securedFields = this.securedClassFields.get(entity.getClass());
            stateToLog = securedFields != null && securedFields.contains(propertyName) ? "__FIELD_VALUE_NOT_AUDITED__" : state;
        }
        TransactionAuditLog delete = this.auditTrailService.auditLogEntry(AuditAction.DELETE, entity, id, propertyName, stateToLog, null, referencedEntity, prev, null);
        if (auditLogStack.get().peek().remove(delete)) {
            log.trace("Replacing exising changelog {}", (Object)delete);
        } else {
            log.trace("Adding new changelog {}", (Object)delete);
        }
        auditLogStack.get().peek().add(delete);
    }

    boolean isAudited(Class<?> entityClass) {
        if (this.includedClasses.contains(entityClass)) {
            return true;
        }
        if (this.ignoredClasses.contains(entityClass)) {
            return false;
        }
        NotAudited notAuditedAnnotation = entityClass.getAnnotation(NotAudited.class);
        if (notAuditedAnnotation != null) {
            log.trace("{} is excluded from auditing", entityClass);
            this.ignoredClasses.add(entityClass);
            return false;
        }
        Audited auditedAnnotation = entityClass.getAnnotation(Audited.class);
        if (auditedAnnotation != null) {
            log.trace("{} is annotated for auditing", entityClass);
            this.includedClasses.add(entityClass);
            ReflectionUtils.doWithFields(entityClass, field -> {
                if (field.getAnnotation(NotAudited.class) != null) {
                    Set ignoredEntityFields = this.ignoredClassFields.computeIfAbsent(entityClass, x -> new HashSet());
                    log.trace("{} property of {} class is excluded from auditing", (Object)field.getName(), (Object)entityClass);
                    ignoredEntityFields.add(field.getName());
                }
                if (field.getAnnotation(HideAuditValue.class) != null) {
                    Set securedFields = this.securedClassFields.computeIfAbsent(entityClass, x -> new HashSet());
                    log.trace("Previous and a new value of {} property of {} class is excluded from persisting", (Object)field.getName(), (Object)entityClass);
                    securedFields.add(field.getName());
                }
            });
            return true;
        }
        for (Class<?> auditedClass : this.auditedClasses) {
            if (!auditedClass.isAssignableFrom(entityClass)) continue;
            log.trace("{} is audited because it is an instance of {}", entityClass, auditedClass);
            this.includedClasses.add(entityClass);
            return true;
        }
        log.trace("{} is not audited", entityClass);
        this.ignoredClasses.add(entityClass);
        return false;
    }

    public void afterTransactionBegin(Transaction tx) {
        Stack<Set<TransactionAuditLog>> transactionLogs = auditLogStack.get();
        transactionLogs.push(new HashSet());
        log.trace("Starting transaction level={}", (Object)transactionLogs.size());
        super.afterTransactionBegin(tx);
    }

    public void beforeTransactionCompletion(Transaction tx) {
        Stack<Set<TransactionAuditLog>> transactionLogs = auditLogStack.get();
        long level = transactionLogs.size();
        Set<TransactionAuditLog> currentAuditLogs = transactionLogs.pop();
        log.trace("beforeTransactionCompletion transaction level={} auditlogs={}", (Object)level, (Object)currentAuditLogs.size());
        if (currentAuditLogs.size() > 0) {
            log.trace("We have {} auditlogs", (Object)currentAuditLogs.size());
            currentAuditLogs.stream().forEach(auditLog -> log.debug("Audit log to save: {}", auditLog));
            if (TransactionStatus.ROLLED_BACK == tx.getStatus()) {
                log.warn("Transaction was rolled back. Audit logs likely won't be persisted");
            }
            this.auditTrailService.addAuditLogs(currentAuditLogs);
            currentAuditLogs.clear();
        }
        super.beforeTransactionCompletion(tx);
    }

    public void afterTransactionCompletion(Transaction tx) {
        long level = auditLogStack.get().size();
        log.trace("afterTransactionCompletion transaction level={}", (Object)level);
        if (TransactionStatus.COMMITTED == tx.getStatus()) {
            log.trace("Transaction was committed, level={}", (Object)level);
        } else if (TransactionStatus.ROLLED_BACK == tx.getStatus()) {
            log.trace("Transaction was rolled back, level={}", (Object)level);
        }
        super.afterTransactionCompletion(tx);
    }

    public Boolean isTransient(Object entity) {
        if (entity instanceof BasicModel) {
            return ((BasicModel)entity).isNew();
        }
        try {
            return this.tryMethod(entity, "getVersion");
        }
        catch (NoSuchMethodException e) {
            try {
                return this.tryMethod(entity, "getId");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                throw new RuntimeException(e.getMessage() + " on " + entity.getClass() + " e=" + entity, e);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage() + " on " + entity.getClass() + " e=" + entity, e);
        }
    }

    public boolean tryMethod(Object entity, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method getter = entity.getClass().getMethod(methodName, new Class[0]);
        Object result = getter.invoke(entity, new Object[0]);
        if (result == null) {
            log.trace("{} is transient, has {} == null", entity, (Object)methodName);
            return true;
        }
        if (result instanceof Number) {
            Number r = (Number)result;
            if (r.longValue() < 0L) {
                log.trace("{} is transient, has {} = {} < 0", new Object[]{entity, methodName, result});
                return true;
            }
            return false;
        }
        return false;
    }
}

