/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.auditlog.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.genesys.blocks.auditlog.annotations.NotAudited;
import org.genesys.blocks.auditlog.model.AuditAction;
import org.genesys.blocks.model.ClassPK;
import org.genesys.blocks.model.EmptyModel;
import org.genesys.blocks.util.JsonSidConverter;
import org.hibernate.annotations.Type;
import org.springframework.data.annotation.CreatedBy;

@Entity
@Table(name="auditlog", indexes={@Index(unique=false, columnList="entityId, classPk, prop")})
@NotAudited
public class AuditLog
extends EmptyModel {
    private static final long serialVersionUID = -2254427722756061411L;
    public static final String FIELD_VALUE_NOT_AUDITED = "__FIELD_VALUE_NOT_AUDITED__";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(nullable=false, length=20)
    protected Long id;
    @CreatedBy
    @JsonSerialize(converter=JsonSidConverter.class)
    private Long createdBy;
    @Column(name="logdate", nullable=false)
    private Instant logDate;
    @ManyToOne(optional=false)
    @JoinColumn(name="classPk")
    private ClassPK classPk;
    @Column(name="entityId")
    private long entityId;
    @Column(nullable=false, name="prop", length=50)
    private String propertyName;
    @ManyToOne(optional=true)
    @JoinColumn(name="entityClassPk")
    private ClassPK referencedEntity;
    @Lob
    @Column(nullable=true)
    @Type(type="org.hibernate.type.TextType")
    private String previousState;
    @Lob
    @Column(nullable=true)
    @Type(type="org.hibernate.type.TextType")
    private String newState;
    @Enumerated(value=EnumType.STRING)
    @Column(length=10, nullable=false, updatable=false)
    private AuditAction action;
    @Transient
    @JsonProperty
    private Object previousEntity;
    @Transient
    @JsonProperty
    private Object newEntity;

    public static AuditLog copy(AuditLog source) {
        AuditLog other = new AuditLog();
        other.id = source.getId();
        other.createdBy = source.getCreatedBy();
        other.logDate = source.getLogDate();
        other.classPk = source.getClassPk();
        other.entityId = source.getEntityId();
        other.propertyName = source.getPropertyName();
        other.referencedEntity = source.getReferencedEntity();
        other.previousState = source.getPreviousState();
        other.newState = source.getNewState();
        other.action = source.getAction();
        other.previousEntity = source.getPreviousEntity();
        other.newEntity = source.getNewEntity();
        return other;
    }

    public boolean canEqual(Object other) {
        return other instanceof AuditLog;
    }

    public Long getId() {
        return this.id;
    }

    public Long getCreatedBy() {
        return this.createdBy;
    }

    public Instant getLogDate() {
        return this.logDate;
    }

    public ClassPK getClassPk() {
        return this.classPk;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ClassPK getReferencedEntity() {
        return this.referencedEntity;
    }

    public String getPreviousState() {
        return this.previousState;
    }

    public String getNewState() {
        return this.newState;
    }

    public AuditAction getAction() {
        return this.action;
    }

    public Object getPreviousEntity() {
        return this.previousEntity;
    }

    public Object getNewEntity() {
        return this.newEntity;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public void setLogDate(Instant logDate) {
        this.logDate = logDate;
    }

    public void setClassPk(ClassPK classPk) {
        this.classPk = classPk;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReferencedEntity(ClassPK referencedEntity) {
        this.referencedEntity = referencedEntity;
    }

    public void setPreviousState(String previousState) {
        this.previousState = previousState;
    }

    public void setNewState(String newState) {
        this.newState = newState;
    }

    public void setAction(AuditAction action) {
        this.action = action;
    }

    @JsonProperty
    public void setPreviousEntity(Object previousEntity) {
        this.previousEntity = previousEntity;
    }

    @JsonProperty
    public void setNewEntity(Object newEntity) {
        this.newEntity = newEntity;
    }

    public String toString() {
        return "AuditLog(super=" + super.toString() + ", id=" + this.getId() + ", createdBy=" + this.getCreatedBy() + ", logDate=" + this.getLogDate() + ", classPk=" + this.getClassPk() + ", entityId=" + this.getEntityId() + ", propertyName=" + this.getPropertyName() + ", referencedEntity=" + this.getReferencedEntity() + ", previousState=" + this.getPreviousState() + ", newState=" + this.getNewState() + ", action=" + this.getAction() + ", previousEntity=" + this.getPreviousEntity() + ", newEntity=" + this.getNewEntity() + ")";
    }
}

