/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.auditlog.model.filters;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.auditlog.model.AuditAction;
import org.genesys.blocks.auditlog.model.AuditLog;
import org.genesys.blocks.auditlog.model.QAuditLog;
import org.genesys.blocks.model.filters.EmptyModelFilter;
import org.genesys.blocks.model.filters.NumberFilter;
import org.genesys.blocks.model.filters.TemporalFilter;

public class AuditLogFilter
extends EmptyModelFilter<AuditLogFilter, AuditLog> {
    private static final long serialVersionUID = -3179751746560952451L;
    public String classname;
    public NumberFilter<Long> entityId;
    public Set<Long> createdBy;
    public Set<AuditAction> action;
    public Set<String> propertyName;
    public TemporalFilter<Instant> logDate;

    public List<Predicate> collectPredicates() {
        return this.collectPredicates(QAuditLog.auditLog);
    }

    public List<Predicate> collectPredicates(QAuditLog auditLog) {
        List predicates = super.collectPredicates((EntityPathBase)auditLog);
        if (this.classname != null) {
            predicates.add(auditLog.classPk.classname.eq((Object)this.classname));
        }
        if (this.entityId != null) {
            predicates.add(this.entityId.buildQuery(auditLog.entityId));
        }
        if (CollectionUtils.isNotEmpty(this.createdBy)) {
            predicates.add(auditLog.createdBy.in(this.createdBy));
        }
        if (CollectionUtils.isNotEmpty(this.action)) {
            predicates.add(auditLog.action.in(this.action));
        }
        if (CollectionUtils.isNotEmpty(this.propertyName)) {
            predicates.add(auditLog.propertyName.in(this.propertyName));
        }
        if (this.logDate != null) {
            predicates.add(this.logDate.buildQuery(auditLog.logDate));
        }
        return predicates;
    }

    public String classname() {
        return this.classname;
    }

    public NumberFilter<Long> entityId() {
        return this.entityId;
    }

    public Set<Long> createdBy() {
        return this.createdBy;
    }

    public Set<AuditAction> action() {
        return this.action;
    }

    public Set<String> propertyName() {
        return this.propertyName;
    }

    public TemporalFilter<Instant> logDate() {
        return this.logDate;
    }

    public AuditLogFilter classname(String classname) {
        this.classname = classname;
        return this;
    }

    public AuditLogFilter entityId(NumberFilter<Long> entityId) {
        this.entityId = entityId;
        return this;
    }

    public AuditLogFilter createdBy(Set<Long> createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public AuditLogFilter action(Set<AuditAction> action) {
        this.action = action;
        return this;
    }

    public AuditLogFilter propertyName(Set<String> propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public AuditLogFilter logDate(TemporalFilter<Instant> logDate) {
        this.logDate = logDate;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditLogFilter)) {
            return false;
        }
        AuditLogFilter other = (AuditLogFilter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$classname = this.classname();
        String other$classname = other.classname();
        if (this$classname == null ? other$classname != null : !this$classname.equals(other$classname)) {
            return false;
        }
        NumberFilter<Long> this$entityId = this.entityId();
        NumberFilter<Long> other$entityId = other.entityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        Set<Long> this$createdBy = this.createdBy();
        Set<Long> other$createdBy = other.createdBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Set<AuditAction> this$action = this.action();
        Set<AuditAction> other$action = other.action();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        Set<String> this$propertyName = this.propertyName();
        Set<String> other$propertyName = other.propertyName();
        if (this$propertyName == null ? other$propertyName != null : !((Object)this$propertyName).equals(other$propertyName)) {
            return false;
        }
        TemporalFilter<Instant> this$logDate = this.logDate();
        TemporalFilter<Instant> other$logDate = other.logDate();
        return !(this$logDate == null ? other$logDate != null : !this$logDate.equals(other$logDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditLogFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $classname = this.classname();
        result = result * 59 + ($classname == null ? 43 : $classname.hashCode());
        NumberFilter<Long> $entityId = this.entityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        Set<Long> $createdBy = this.createdBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Set<AuditAction> $action = this.action();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        Set<String> $propertyName = this.propertyName();
        result = result * 59 + ($propertyName == null ? 43 : ((Object)$propertyName).hashCode());
        TemporalFilter<Instant> $logDate = this.logDate();
        result = result * 59 + ($logDate == null ? 43 : $logDate.hashCode());
        return result;
    }
}

