/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.auditlog.persistence;

import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.genesys.blocks.auditlog.model.AuditLog;
import org.genesys.blocks.auditlog.model.filters.AuditLogFilter;
import org.genesys.blocks.auditlog.persistence.AuditLogCustomRepository;
import org.genesys.blocks.auditlog.persistence.AuditLogRepository;
import org.genesys.blocks.model.ClassPK;
import org.genesys.blocks.model.EntityId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class AuditLogRepositoryCustomImpl
implements AuditLogCustomRepository {
    private static final Logger log = LoggerFactory.getLogger(AuditLogRepositoryCustomImpl.class);
    @Autowired
    private AuditLogRepository repository;
    @Autowired
    private EntityManager entityManager;

    @Override
    public List<AuditLog> listAuditLogs(EntityId entity) {
        if (entity == null) {
            return new ArrayList<AuditLog>();
        }
        return this.repository.listAuditLogs(entity.getClass().getName(), entity.getId());
    }

    @Override
    public AuditLog getLastAuditLog(EntityId entity) {
        List<AuditLog> l = this.repository.listAuditLogs(entity.getClass().getName(), entity.getId(), (Pageable)PageRequest.of((int)0, (int)1));
        return l == null || l.isEmpty() ? null : l.get(0);
    }

    @Override
    public AuditLog getLastAuditLog(EntityId entity, String propertyName) {
        List<AuditLog> l = this.repository.listAuditLogs(entity.getClass().getName(), entity.getId(), propertyName, (Pageable)PageRequest.of((int)0, (int)1));
        return l == null || l.isEmpty() ? null : l.get(0);
    }

    @Override
    public Page<AuditLog> listAuditLogs(AuditLogFilter filters, Pageable page) {
        return this.repository.findAll((Predicate)filters.buildPredicate(), page);
    }

    @Override
    public Object get(ClassPK classPk, Long id) {
        if (id == null || classPk == null || classPk.getClassname() == null) {
            return null;
        }
        log.trace("Looking up {} id={}", (Object)classPk.getClassname(), (Object)id);
        try {
            return this.entityManager.find(Class.forName(classPk.getClassname()), (Object)id);
        }
        catch (ClassNotFoundException e) {
            log.warn("Audit log references a missing class: {}", (Object)e.getMessage());
            return null;
        }
    }
}

