/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.auditlog.service.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.genesys.blocks.auditlog.model.AuditAction;
import org.genesys.blocks.auditlog.model.AuditLog;
import org.genesys.blocks.auditlog.model.TransactionAuditLog;
import org.genesys.blocks.auditlog.model.filters.AuditLogFilter;
import org.genesys.blocks.auditlog.persistence.AuditLogRepository;
import org.genesys.blocks.auditlog.service.AuditTrailService;
import org.genesys.blocks.auditlog.service.ClassPKService;
import org.genesys.blocks.model.ClassPK;
import org.genesys.blocks.model.EntityId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AuditTrailServiceImpl
implements AuditTrailService {
    private static final Logger log = LoggerFactory.getLogger(AuditTrailServiceImpl.class);
    @Autowired
    private ClassPKService classPkService;
    @Autowired
    private AuditLogRepository auditLogRepository;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED, propagation=Propagation.REQUIRED)
    public List<AuditLog> addAuditLogs(Set<TransactionAuditLog> auditLogs) {
        return this.auditLogRepository.saveAll(auditLogs.stream().map(tlog -> this.toAuditLog((TransactionAuditLog)tlog)).collect(Collectors.toList()));
    }

    @Override
    public TransactionAuditLog auditLogEntry(AuditAction action, Object entity, long id, String propertyName, String previousState, String currentState, Class<?> referencedEntity, Object previousObject, Object currentObject) {
        TransactionAuditLog auditLog = new TransactionAuditLog();
        auditLog.setAction(action);
        auditLog.setClassPk(this.classPkService.getClassPk(entity.getClass()));
        auditLog.setEntityId(id);
        auditLog.setPropertyName(propertyName);
        auditLog.setPreviousState(previousState);
        auditLog.setNewState(currentState);
        auditLog.setPreviousObject(previousObject);
        auditLog.setNewObject(currentObject);
        if (referencedEntity != null) {
            auditLog.setReferencedEntity(this.classPkService.getClassPk(referencedEntity));
        }
        log.trace("Creating {} audit log entity={} id={} prop={} old={} new={} ref={}", new Object[]{action, entity.getClass().getName(), id, propertyName, previousState, currentState, referencedEntity == null ? null : referencedEntity.getName()});
        return auditLog;
    }

    private AuditLog toAuditLog(TransactionAuditLog tlog) {
        AuditLog auditLog = new AuditLog();
        auditLog.setLogDate(Instant.now());
        auditLog.setAction(tlog.getAction());
        auditLog.setClassPk(tlog.getClassPk());
        auditLog.setEntityId(tlog.getEntityId());
        auditLog.setNewState(tlog.getNewState());
        auditLog.setPreviousState(tlog.getPreviousState());
        auditLog.setPropertyName(tlog.getPropertyName());
        auditLog.setReferencedEntity(tlog.getReferencedEntity());
        auditLog.setPreviousEntity(tlog.getPreviousObject());
        auditLog.setNewEntity(tlog.getNewObject());
        return auditLog;
    }

    @Override
    public Page<AuditLog> listAuditLogs(AuditLogFilter filters, Pageable page) {
        return this.auditLogRepository.listAuditLogs(filters, page);
    }

    @Override
    public List<AuditLog> listAuditLogs(EntityId entity) {
        List<AuditLog> auditLogs = this.auditLogRepository.listAuditLogs(entity);
        auditLogs.stream().filter(auditLog -> auditLog.getReferencedEntity() != null).forEach(auditLog -> {
            ClassPK referencedClassPk = auditLog.getReferencedEntity();
            log.trace("Loading referenced entity {}", (Object)referencedClassPk);
            if (auditLog.getPreviousState() != null) {
                auditLog.setPreviousEntity(this.auditLogRepository.get(referencedClassPk, NumberUtils.toLong((String)auditLog.getPreviousState())));
            }
            if (auditLog.getNewState() != null) {
                auditLog.setNewEntity(this.auditLogRepository.get(referencedClassPk, NumberUtils.toLong((String)auditLog.getNewState())));
            }
        });
        return auditLogs;
    }

    @Override
    public Map<String, List<AuditLog>> auditLogs(EntityId entity) {
        HashMap<String, List<AuditLog>> logMap = new HashMap<String, List<AuditLog>>();
        this.listAuditLogs(entity).stream().forEach(auditLog -> {
            ArrayList<AuditLog> m = (ArrayList<AuditLog>)logMap.get(auditLog.getPropertyName());
            if (m == null) {
                m = new ArrayList<AuditLog>();
                logMap.put(auditLog.getPropertyName(), m);
            }
            m.add((AuditLog)((Object)auditLog));
        });
        return logMap;
    }
}

