/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.auditlog.service.impl;

import java.util.Optional;
import javax.persistence.PersistenceException;
import org.genesys.blocks.auditlog.service.ClassPKService;
import org.genesys.blocks.model.ClassPK;
import org.genesys.blocks.persistence.ClassPKRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ClassPKServiceImpl
implements ClassPKService {
    private static final Logger log = LoggerFactory.getLogger(ClassPKServiceImpl.class);
    @Autowired
    private ClassPKRepository classPkRepository;

    @Override
    @Transactional(isolation=Isolation.DEFAULT, propagation=Propagation.REQUIRES_NEW)
    @Cacheable(cacheNames={"classPk"}, unless="#result == null")
    public ClassPK getClassPk(Class<?> class1) {
        ClassPK classPk = this.classPkRepository.getByClassname(class1.getName());
        if (classPk != null) {
            return classPk;
        }
        return this.createNewClassPkForClass(class1);
    }

    private String generateShortPkName(String shortName) {
        ClassPK classPk = null;
        Object candidate = shortName;
        int i = 0;
        do {
            if ((classPk = this.classPkRepository.findByShortName((String)candidate)) == null) {
                return candidate;
            }
            candidate = shortName + ++i;
        } while (i < 10);
        throw new PersistenceException("Can't generate a shortName for ClassPK for " + shortName);
    }

    @Override
    @Transactional(isolation=Isolation.DEFAULT, propagation=Propagation.REQUIRES_NEW)
    public String getClassName(Long id) {
        Optional classPK = this.classPkRepository.findById((Object)id);
        return classPK.map(ClassPK::getClassname).orElse(null);
    }

    @Override
    public ClassPK findByShortName(String classPKShortName) {
        return this.classPkRepository.findByShortName(classPKShortName);
    }

    @Override
    @Transactional
    public Long getClassPkId(String classname) {
        Long id = this.classPkRepository.getClassPkId(classname);
        if (id == null) {
            try {
                Class<?> aClass = Class.forName(classname);
                return this.getClassPk(aClass).getId();
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return id;
    }

    private ClassPK createNewClassPkForClass(Class<?> aClass) {
        ClassPK classPk = new ClassPK();
        classPk.setClassname(aClass.getName());
        classPk.setShortName(this.generateShortPkName(aClass.getSimpleName().toLowerCase()));
        log.trace("Persisting new ClassPK for {}", (Object)classPk);
        return (ClassPK)this.classPkRepository.save((Object)classPk);
    }
}

