/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.Version;
import org.genesys.blocks.model.Activatable;
import org.genesys.blocks.model.BasicModel;

@MappedSuperclass
public abstract class VersionedModel
extends BasicModel
implements Activatable {
    static final boolean DEFAULT_ACTIVE_VALUE = true;
    private static final long serialVersionUID = 6486704708017489425L;
    @Version
    @Column(nullable=false)
    Integer version = null;
    @Column(nullable=false)
    protected boolean active = true;

    @PrePersist
    private void prepersistVersionedModel() {
        this.version = 1;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedModel other = (VersionedModel)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public String toString() {
        return super.toString() + " version=" + this.version + " active=" + this.active;
    }
}

