/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.filters.PropertyFilter;

public class StringFilter
implements PropertyFilter<StringFilter, StringPath> {
    private static final long serialVersionUID = -1950139291270046687L;
    @JsonDeserialize(using=SetDeserializer.class)
    public Set<String> eq;
    @JsonDeserialize(using=SetDeserializer.class)
    public Set<String> contains;
    @JsonDeserialize(using=SetDeserializer.class)
    public Set<String> sw;

    @Override
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.eq) && CollectionUtils.isEmpty(this.contains) && CollectionUtils.isEmpty(this.sw);
    }

    @Override
    public StringFilter copyFilter() {
        return new StringFilter().eq((Set<String>)(this.eq == null ? null : new HashSet<String>(this.eq))).contains((Set<String>)(this.contains == null ? null : new HashSet<String>(this.contains))).sw((Set<String>)(this.sw == null ? null : new HashSet<String>(this.sw)));
    }

    public BooleanBuilder buildQuery(StringPath val) {
        BooleanBuilder and = new BooleanBuilder();
        if (this.eq != null && !this.eq.isEmpty()) {
            and.and((Predicate)val.isNotNull()).and((Predicate)val.in(this.eq));
        }
        if (this.sw != null && !this.sw.isEmpty()) {
            and.and((Predicate)val.isNotNull()).andAnyOf((Predicate[])this.sw.stream().map(arg_0 -> ((StringPath)val).startsWith(arg_0)).toArray(Predicate[]::new));
        }
        if (this.contains != null && !this.contains.isEmpty()) {
            and.and((Predicate)val.isNotNull()).andAnyOf((Predicate[])this.contains.stream().map(arg_0 -> ((StringPath)val).contains(arg_0)).toArray(Predicate[]::new));
        }
        return and;
    }

    public Set<String> eq() {
        return this.eq;
    }

    public Set<String> contains() {
        return this.contains;
    }

    public Set<String> sw() {
        return this.sw;
    }

    @JsonDeserialize(using=SetDeserializer.class)
    public StringFilter eq(Set<String> eq) {
        this.eq = eq;
        return this;
    }

    @JsonDeserialize(using=SetDeserializer.class)
    public StringFilter contains(Set<String> contains) {
        this.contains = contains;
        return this;
    }

    @JsonDeserialize(using=SetDeserializer.class)
    public StringFilter sw(Set<String> sw) {
        this.sw = sw;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringFilter)) {
            return false;
        }
        StringFilter other = (StringFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$eq = this.eq();
        Set<String> other$eq = other.eq();
        if (this$eq == null ? other$eq != null : !((Object)this$eq).equals(other$eq)) {
            return false;
        }
        Set<String> this$contains = this.contains();
        Set<String> other$contains = other.contains();
        if (this$contains == null ? other$contains != null : !((Object)this$contains).equals(other$contains)) {
            return false;
        }
        Set<String> this$sw = this.sw();
        Set<String> other$sw = other.sw();
        return !(this$sw == null ? other$sw != null : !((Object)this$sw).equals(other$sw));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $eq = this.eq();
        result = result * 59 + ($eq == null ? 43 : ((Object)$eq).hashCode());
        Set<String> $contains = this.contains();
        result = result * 59 + ($contains == null ? 43 : ((Object)$contains).hashCode());
        Set<String> $sw = this.sw();
        result = result * 59 + ($sw == null ? 43 : ((Object)$sw).hashCode());
        return result;
    }

    public String toString() {
        return "StringFilter(eq=" + this.eq() + ", contains=" + this.contains() + ", sw=" + this.sw() + ")";
    }

    static class SetDeserializer
    extends JsonDeserializer<Set<String>> {
        SetDeserializer() {
        }

        public Set<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            HashSet<String> values = new HashSet<String>();
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                while (jsonParser.getCurrentToken() != null && jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    if (jsonParser.nextToken() != JsonToken.VALUE_STRING) continue;
                    values.add(jsonParser.getText());
                }
            } else if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                values.add(jsonParser.getText());
            }
            return values;
        }
    }
}

