/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CollectionPathBase;
import com.querydsl.core.types.dsl.DslExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.genesys.blocks.model.filters.Filter;
import org.genesys.blocks.util.FilterUtils;
import org.springframework.util.ReflectionUtils;

public abstract class SuperModelFilter<T extends SuperModelFilter<T, R>, R>
implements Filter {
    private static final long serialVersionUID = -4298821420228268854L;
    private static final ObjectMapper jsonizer = new ObjectMapper();
    private static final ObjectMapper defaultMapper = new ObjectMapper();
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Set<String> NULL;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Set<String> NOTNULL;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public T NOT;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public T AND;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public T OR;
    private static final Map<Class<?>, List<Field>> CACHED_FILTER_FIELDS;

    @Override
    public final boolean isEmpty() {
        List<Field> filterFields = SuperModelFilter.getFilterFields(this.getClass());
        for (Field field : filterFields) {
            try {
                Object filterField = field.get(this);
                if (filterField == null) continue;
                if (filterField instanceof Filter) {
                    if (FilterUtils.isEmpty((Filter)filterField)) continue;
                    return false;
                }
                if (filterField instanceof Collection) {
                    if (FilterUtils.isEmpty((Collection)filterField)) continue;
                    return false;
                }
                if (filterField instanceof String) {
                    if (Objects.equals("", filterField)) continue;
                    return false;
                }
                if (filterField instanceof Boolean) {
                    return false;
                }
                throw new Exception("Unhandled type" + filterField.getClass());
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot handle property " + field.getName() + " in " + field.getDeclaringClass().getName(), e);
            }
        }
        return true;
    }

    private static final List<Field> getFilterFields(Class<?> clazz) {
        return CACHED_FILTER_FIELDS.computeIfAbsent(clazz, key -> {
            LinkedList fields = new LinkedList();
            ReflectionUtils.doWithFields((Class)clazz, fields::add, field -> {
                int modifiers = field.getModifiers();
                return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
            });
            return Collections.unmodifiableList(fields);
        });
    }

    public abstract List<Predicate> collectPredicates();

    public String[] boostedFields() {
        return null;
    }

    public Map<String, String> remappedProperties() {
        return null;
    }

    public BooleanBuilder buildPredicate() {
        BooleanBuilder builder = new BooleanBuilder(ExpressionUtils.allOf(this.collectPredicates()));
        if (this.NOT != null) {
            builder.and(ExpressionUtils.anyOf(((SuperModelFilter)this.NOT).collectPredicates()).not());
        }
        if (this.AND != null) {
            builder.and((Predicate)((SuperModelFilter)this.AND).buildPredicate());
        }
        if (this.OR != null) {
            builder.or((Predicate)((SuperModelFilter)this.OR).buildPredicate());
        }
        return builder;
    }

    protected List<Predicate> collectPredicates(EntityPathBase<R> instance) {
        Class<?> clazz;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.NULL != null && !this.NULL.isEmpty()) {
            clazz = instance.getClass();
            this.NULL.forEach(nullProp -> {
                DslExpression<?> expression = this.getProperty(instance, clazz, (String)nullProp);
                if (expression instanceof SimpleExpression) {
                    predicates.add((Predicate)((SimpleExpression)expression).isNull());
                } else if (expression instanceof CollectionPathBase) {
                    predicates.add((Predicate)((CollectionPathBase)expression).size().eq((Object)0));
                }
            });
        }
        if (this.NOTNULL != null && !this.NOTNULL.isEmpty()) {
            clazz = instance.getClass();
            this.NOTNULL.forEach(notNullProp -> {
                DslExpression<?> expression = this.getProperty(instance, clazz, (String)notNullProp);
                if (expression instanceof SimpleExpression) {
                    predicates.add((Predicate)((SimpleExpression)expression).isNotNull());
                } else if (expression instanceof CollectionPathBase) {
                    predicates.add((Predicate)((CollectionPathBase)expression).size().gt((Number)0));
                }
            });
        }
        return predicates;
    }

    public void clearFilter(String jsonPath) throws NoSuchFieldException, IllegalAccessException {
        this.clearFilter(jsonPath, true);
    }

    public final void clearFilter(String jsonPath, boolean clearNullAndNotNull) throws NoSuchFieldException, IllegalAccessException {
        if (clearNullAndNotNull) {
            this.removeFromNullAndNotNull(jsonPath);
        }
        String[] paths = jsonPath.split("\\.");
        Object toClear = this;
        Class<?> clazz = this.getClass();
        Field field = clazz.getField(paths[0]);
        for (int i = 1; i < paths.length && SuperModelFilter.class.isAssignableFrom(clazz = field.getType()); ++i) {
            if ((toClear = field.get(toClear)) == null) {
                return;
            }
            field = clazz.getField(paths[i]);
        }
        field.set(toClear, null);
    }

    protected final void removeFromNullAndNotNull(String jsonPath) {
        if (this.NULL != null && this.NULL.contains(jsonPath)) {
            this.NULL = new HashSet<String>(this.NULL);
            this.NULL.remove(jsonPath);
        }
        if (this.NOTNULL != null && this.NOTNULL.contains(jsonPath)) {
            this.NOTNULL = new HashSet<String>(this.NOTNULL);
            this.NOTNULL.remove(jsonPath);
        }
    }

    private DslExpression<?> getProperty(EntityPathBase<R> instance, Class<?> clazz, String nullProp) {
        if (this.remappedProperties() != null) {
            nullProp = this.remappedProperties().getOrDefault(nullProp, nullProp);
        }
        try {
            block24: {
                if (nullProp.contains(".")) {
                    String[] paths = nullProp.split("\\.");
                    PathBuilder pathBuilder = new PathBuilder(instance.getType(), instance.getMetadata());
                    Class<?> clazzToCheck = clazz;
                    boolean isCollection = false;
                    for (String path : paths) {
                        Field field = ReflectionUtils.findField(clazzToCheck, (String)path);
                        if (field == null) {
                            throw new NoSuchFieldException("Property " + nullProp + " is not a SimpleExpression");
                        }
                        if (CollectionPathBase.class.isAssignableFrom(field.getType())) {
                            isCollection = true;
                        } else {
                            isCollection = false;
                            pathBuilder.getSimple(path, field.getDeclaringClass());
                        }
                        clazzToCheck = field.getType();
                    }
                    if (isCollection) {
                        return pathBuilder.getSet(nullProp, clazzToCheck);
                    }
                    return pathBuilder.getSimple(nullProp, clazzToCheck);
                }
                Field prop = ReflectionUtils.findField(clazz, (String)nullProp);
                if (prop != null) {
                    try {
                        if (SimpleExpression.class.isAssignableFrom(prop.getType())) {
                            return (SimpleExpression)prop.get(instance);
                        }
                        if (CollectionPathBase.class.isAssignableFrom(prop.getType())) {
                            return (CollectionPathBase)prop.get(instance);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Method accessor = ReflectionUtils.findMethod(clazz, (String)prop.getName());
                        if (accessor == null) break block24;
                        if (SimpleExpression.class.isAssignableFrom(prop.getType())) {
                            return (SimpleExpression)accessor.invoke(instance, new Object[0]);
                        }
                        if (!CollectionPathBase.class.isAssignableFrom(prop.getType())) break block24;
                        return (CollectionPathBase)accessor.invoke(instance, new Object[0]);
                    }
                }
            }
            throw new NoSuchFieldException("Property " + nullProp + " is not a SimpleExpression");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
            if (e instanceof NoSuchFieldException) {
                Field[] fields;
                Set<Class<EntityPathBase<R>>> subclasses = this.getSubClasses();
                for (Class<EntityPathBase<R>> subclass : subclasses) {
                    try {
                        Field prop = subclass.getField(nullProp);
                        PathBuilder pathBuilder = new PathBuilder(instance.getType(), instance.getMetadata());
                        if (CollectionPathBase.class.isAssignableFrom(prop.getType())) {
                            return pathBuilder.getSet(nullProp, prop.getDeclaringClass());
                        }
                        return pathBuilder.getSimple(prop.getName(), prop.getDeclaringClass());
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                }
                for (Field field : fields = clazz.getDeclaredFields()) {
                    Class<?> superClazz = field.getType().getSuperclass();
                    if (superClazz == null || !EntityPathBase.class.isAssignableFrom(superClazz)) continue;
                    try {
                        Field result = field.getType().getField(nullProp);
                        PathBuilder pathBuilder = new PathBuilder(instance.getType(), instance.getMetadata());
                        if (CollectionPathBase.class.isAssignableFrom(result.getType())) {
                            return pathBuilder.getSet(field.getName() + "." + nullProp, result.getDeclaringClass());
                        }
                        return pathBuilder.getSimple(field.getName() + "." + nullProp, result.getDeclaringClass());
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            throw new RuntimeException("Error accessing field " + nullProp + " for isNull() in " + instance.getClass());
        }
    }

    protected Set<Class<? extends EntityPathBase<? extends R>>> getSubClasses() {
        return new HashSet<Class<? extends EntityPathBase<? extends R>>>();
    }

    public <X> X copy(Class<X> targetType) {
        try {
            String json = defaultMapper.writeValueAsString((Object)this);
            return (X)jsonizer.readValue(json, targetType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not copy filter", e);
        }
    }

    public String toString() {
        try {
            return jsonizer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not serialize to JSON: " + e.getMessage(), e);
        }
    }

    public static <Y extends SuperModelFilter<Y, ?>> Y normalize(Y filter) {
        HashSet<String> toClear = new HashSet<String>();
        if (filter.NULL != null) {
            toClear.addAll(filter.NULL);
        }
        if (filter.NOTNULL != null) {
            toClear.addAll(filter.NOTNULL);
        }
        for (String path : toClear) {
            try {
                filter.clearFilter(path, false);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                filter.removeFromNullAndNotNull(path);
            }
        }
        if (filter.AND != null) {
            filter.AND = SuperModelFilter.normalize(filter.AND);
        }
        if (filter.OR != null) {
            filter.OR = SuperModelFilter.normalize(filter.OR);
        }
        if (filter.NOT != null) {
            filter.NOT = SuperModelFilter.normalize(filter.NOT);
        }
        return filter;
    }

    public Set<String> NULL() {
        return this.NULL;
    }

    public Set<String> NOTNULL() {
        return this.NOTNULL;
    }

    public T NOT() {
        return this.NOT;
    }

    public T AND() {
        return this.AND;
    }

    public T OR() {
        return this.OR;
    }

    public SuperModelFilter<T, R> NULL(Set<String> NULL) {
        this.NULL = NULL;
        return this;
    }

    public SuperModelFilter<T, R> NOTNULL(Set<String> NOTNULL) {
        this.NOTNULL = NOTNULL;
        return this;
    }

    public SuperModelFilter<T, R> NOT(T NOT) {
        this.NOT = NOT;
        return this;
    }

    public SuperModelFilter<T, R> AND(T AND) {
        this.AND = AND;
        return this;
    }

    public SuperModelFilter<T, R> OR(T OR) {
        this.OR = OR;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuperModelFilter)) {
            return false;
        }
        SuperModelFilter other = (SuperModelFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$NULL = this.NULL();
        Set<String> other$NULL = other.NULL();
        if (this$NULL == null ? other$NULL != null : !((Object)this$NULL).equals(other$NULL)) {
            return false;
        }
        Set<String> this$NOTNULL = this.NOTNULL();
        Set<String> other$NOTNULL = other.NOTNULL();
        if (this$NOTNULL == null ? other$NOTNULL != null : !((Object)this$NOTNULL).equals(other$NOTNULL)) {
            return false;
        }
        T this$NOT = this.NOT();
        T other$NOT = other.NOT();
        if (this$NOT == null ? other$NOT != null : !this$NOT.equals(other$NOT)) {
            return false;
        }
        T this$AND = this.AND();
        T other$AND = other.AND();
        if (this$AND == null ? other$AND != null : !this$AND.equals(other$AND)) {
            return false;
        }
        T this$OR = this.OR();
        T other$OR = other.OR();
        return !(this$OR == null ? other$OR != null : !this$OR.equals(other$OR));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuperModelFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $NULL = this.NULL();
        result = result * 59 + ($NULL == null ? 43 : ((Object)$NULL).hashCode());
        Set<String> $NOTNULL = this.NOTNULL();
        result = result * 59 + ($NOTNULL == null ? 43 : ((Object)$NOTNULL).hashCode());
        T $NOT = this.NOT();
        result = result * 59 + ($NOT == null ? 43 : $NOT.hashCode());
        T $AND = this.AND();
        result = result * 59 + ($AND == null ? 43 : $AND.hashCode());
        T $OR = this.OR();
        result = result * 59 + ($OR == null ? 43 : $OR.hashCode());
        return result;
    }

    static {
        jsonizer.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        defaultMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        jsonizer.registerModule((Module)javaTimeModule);
        defaultMapper.registerModule((Module)javaTimeModule);
        CACHED_FILTER_FIELDS = new HashMap();
    }
}

