/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.QVersionedModel;
import org.genesys.blocks.model.VersionedModel;
import org.genesys.blocks.model.filters.BasicModelFilter;

public abstract class VersionedModelFilter<T extends VersionedModelFilter<T, R>, R extends VersionedModel>
extends BasicModelFilter<T, R> {
    private static final long serialVersionUID = -4226770121644301621L;
    public Set<Integer> version;
    public Boolean active;

    protected List<Predicate> collectPredicates(EntityPathBase<R> instance, QVersionedModel versionedModel) {
        List<Predicate> predicates = super.collectPredicates(instance);
        if (CollectionUtils.isNotEmpty(this.version)) {
            predicates.add((Predicate)versionedModel.version.in(this.version));
        }
        if (this.active != null) {
            predicates.add((Predicate)versionedModel.active.eq(this.active));
        }
        return predicates;
    }

    public Set<Integer> version() {
        return this.version;
    }

    public Boolean active() {
        return this.active;
    }

    public VersionedModelFilter<T, R> version(Set<Integer> version) {
        this.version = version;
        return this;
    }

    public VersionedModelFilter<T, R> active(Boolean active) {
        this.active = active;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionedModelFilter)) {
            return false;
        }
        VersionedModelFilter other = (VersionedModelFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.active();
        Boolean other$active = other.active();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Set<Integer> this$version = this.version();
        Set<Integer> other$version = other.version();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VersionedModelFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $active = this.active();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Set<Integer> $version = this.version();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

