/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.converter.Converter;

public abstract class StringToJavaTimeConverter {

    public static class StringToLocalDateConverter
    implements Converter<String, LocalDate> {
        public static StringToLocalDateConverter INSTANCE = new StringToLocalDateConverter();

        private StringToLocalDateConverter() {
        }

        public LocalDate convert(String source) {
            if (source.length() == 10) {
                return LocalDate.parse(source);
            }
            return LocalDate.parse(source.subSequence(0, 10));
        }
    }

    public static class StringToInstantConverter
    implements Converter<String, Instant> {
        public static StringToInstantConverter INSTANCE = new StringToInstantConverter();

        private StringToInstantConverter() {
        }

        public Instant convert(String source) {
            TemporalAccessor dt;
            if (source.length() == 10) {
                return this.convertDateToInstantWithTimeZone(source);
            }
            try {
                dt = DateTimeFormatter.ISO_DATE_TIME.parseBest(source, OffsetDateTime::from, ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
            }
            catch (Exception e) {
                return LocalDate.ofInstant(Instant.ofEpochMilli(Long.parseLong(source)), ZoneId.systemDefault()).atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            if (dt instanceof ZonedDateTime) {
                return ((ZonedDateTime)dt).toInstant();
            }
            if (dt instanceof OffsetDateTime) {
                return ((OffsetDateTime)dt).toInstant();
            }
            if (dt instanceof LocalDateTime) {
                return ((LocalDateTime)dt).toInstant(ZoneOffset.UTC);
            }
            if (dt instanceof LocalDate) {
                return ((LocalDate)dt).atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            throw new DateTimeParseException("IDK", source, 0);
        }

        private Instant convertDateToInstantWithTimeZone(String date) {
            TimeZone timeZone = LocaleContextHolder.getTimeZone();
            return LocalDate.parse(date).atStartOfDay(timeZone.toZoneId()).withZoneSameInstant(ZoneId.of("UTC")).toInstant();
        }
    }
}

