/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.model;

import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.genesys2.server.filerepository.metadata.BaseMetadata;
import org.genesys2.server.filerepository.model.BaseEntity;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

@Entity
@Table(name="repositoryfile", indexes={@Index(unique=false, columnList="path", name="IX_repoFile_path")})
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class RepositoryFile
extends BaseEntity
implements BaseMetadata {
    @Column(name="uuid", unique=true, nullable=false, updatable=false, columnDefinition="binary(16)")
    private UUID uuid;
    @Column(name="path", nullable=false)
    private String path;
    @Column(name="originalFilename", nullable=false)
    private String originalFilename;
    @Column(name="extension")
    private String extension;
    @Column(name="title")
    private String title;
    @Column(name="subject")
    private String subject;
    @Column(name="description")
    private String description;
    @Column(name="creator")
    private String creator;
    @Column(name="created")
    private String created;
    @Column(name="rightsHolder")
    private String rightsHolder;
    @Column(name="accessRights")
    private String accessRights;
    @Column(name="license")
    private String license;
    @Column(name="mimeType")
    private String mimeType;
    @Column(name="extent")
    private String extent;
    @Column(name="bibliographicCitation")
    private String bibliographicCitation;
    @CreatedDate
    @Column(name="createdDate")
    private Date createdDate;
    @LastModifiedDate
    @Column(name="lastModifiedDate")
    private Date lastModifiedDate;
    @Column(length=400, nullable=true)
    private String originalUrl;
    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateRetrieved;

    @PrePersist
    protected void prePersist() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
    }

    @Override
    @Transient
    public String getIdentifier() {
        return "urn:uuid:" + this.uuid.toString();
    }

    @Transient
    public String getUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.path).append(this.getFilename());
        return sb.toString();
    }

    @Transient
    public String getFilename() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.uuid.toString());
        if (this.extension != null) {
            sb.append(this.extension);
        }
        return sb.toString();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    protected void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    @Override
    public String getRightsHolder() {
        return this.rightsHolder;
    }

    public void setRightsHolder(String rightsHolder) {
        this.rightsHolder = rightsHolder;
    }

    @Override
    public String getAccessRights() {
        return this.accessRights;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public String getFormat() {
        return this.getMimeType();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    @Override
    public String getBibliographicCitation() {
        return this.bibliographicCitation;
    }

    public void setBibliographicCitation(String bibliographicCitation) {
        this.bibliographicCitation = bibliographicCitation;
    }

    @Override
    public Date getDateSubmitted() {
        return this.getCreatedDate();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public Date getModified() {
        return this.getLastModifiedDate();
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setOriginalFilename(String originalFilename) {
        int dotIndex = originalFilename.lastIndexOf(".");
        this.originalFilename = originalFilename;
        this.setExtension(dotIndex > 0 ? originalFilename.substring(dotIndex) : null);
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getExtension() {
        return this.extension;
    }

    protected void setExtension(String extension) {
        this.extension = extension;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public Date getDateRetrieved() {
        return this.dateRetrieved;
    }

    public void setDateRetrieved(Date dateRetrieved) {
        this.dateRetrieved = dateRetrieved;
    }
}

