/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.genesys2.server.filerepository.metadata.ImageMetadata;
import org.genesys2.server.filerepository.model.RepositoryFile;

@Entity
@Table(name="repositoryimage")
public class RepositoryImage
extends RepositoryFile
implements ImageMetadata {
    @Column(name="width")
    private int width;
    @Column(name="height")
    private int height;
    @Enumerated(value=EnumType.ORDINAL)
    private ImageMetadata.Orientation orientation;

    @Override
    @PrePersist
    protected void prePersist() {
        super.prePersist();
        this.updateOrientation();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateOrientation();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.updateOrientation();
    }

    @Override
    public ImageMetadata.Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ImageMetadata.Orientation orientation) {
        this.orientation = orientation;
    }

    private void updateOrientation() {
        this.orientation = this.width > this.height ? ImageMetadata.Orientation.LANDSCAPE : ImageMetadata.Orientation.PORTRAIT;
    }
}

