/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.service.aspect;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.genesys2.server.filerepository.model.ImageGallery;
import org.genesys2.server.filerepository.model.RepositoryImage;
import org.genesys2.server.filerepository.service.ImageGalleryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ImageGalleryAspects {
    private static final Logger LOG = LoggerFactory.getLogger(ImageGalleryAspects.class);
    @Autowired
    private ImageGalleryService imageGalleryService;

    @AfterReturning(value="execution(* org.genesys2.server.filerepository.persistence.RepositoryImagePersistence.save(*))", returning="repositoryImages")
    public Object afterRepositoryImageSaveIterable(JoinPoint joinPoint, Iterable<RepositoryImage> repositoryImages) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Many images were saved: " + repositoryImages);
        }
        if (repositoryImages != null) {
            repositoryImages.forEach(ri -> this.addImageToGallery((RepositoryImage)ri));
        }
        return repositoryImages;
    }

    @AfterReturning(value="execution(* org.genesys2.server.filerepository.persistence.RepositoryImagePersistence.save(*))", returning="repositoryImage")
    public Object afterRepositoryImageSave(JoinPoint joinPoint, RepositoryImage repositoryImage) throws Throwable {
        if (LOG.isTraceEnabled()) {
            LOG.trace("1 image was saved: " + repositoryImage);
        }
        if (repositoryImage != null) {
            this.addImageToGallery(repositoryImage);
        }
        return repositoryImage;
    }

    @Around(value="execution(* org.genesys2.server.filerepository.persistence.RepositoryImagePersistence.delete(*)) && args(repositoryImage)")
    public Object aroundRepositoryImageDelete(ProceedingJoinPoint joinPoint, RepositoryImage repositoryImage) throws Throwable {
        if (LOG.isTraceEnabled() && repositoryImage != null) {
            LOG.trace("1 image is being deleted path={} originalFilename={}", (Object)repositoryImage.getPath(), (Object)repositoryImage.getOriginalFilename());
        }
        this.removeImageFromGallery(repositoryImage);
        try {
            joinPoint.proceed();
        }
        catch (Throwable e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Putting image back to gallery.");
            }
            this.addImageToGallery(repositoryImage);
            throw e;
        }
        return repositoryImage;
    }

    private void addImageToGallery(RepositoryImage repositoryImage) {
        if (repositoryImage == null) {
            return;
        }
        ImageGallery imageGallery = this.imageGalleryService.loadImageGallery(repositoryImage.getPath());
        if (imageGallery == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No gallery at path=" + repositoryImage.getPath());
            }
            return;
        }
        List<RepositoryImage> imagesList = imageGallery.getImages();
        if (imagesList == null) {
            imagesList = new ArrayList<RepositoryImage>(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding " + repositoryImage + " to image gallery at path=" + imageGallery.getPath());
        }
        imagesList.add(repositoryImage);
        this.imageGalleryService.saveImageOrder(imageGallery);
    }

    private void removeImageFromGallery(RepositoryImage repositoryImage) {
        if (repositoryImage == null) {
            return;
        }
        ImageGallery imageGallery = this.imageGalleryService.loadImageGallery(repositoryImage.getPath());
        if (imageGallery == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No gallery at path=" + repositoryImage.getPath());
            }
            return;
        }
        List<RepositoryImage> imagesList = imageGallery.getImages();
        if (imagesList == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Images size=" + imagesList.size());
            LOG.trace("Removing " + repositoryImage + " from image gallery at path=" + imageGallery.getPath());
        }
        imagesList.remove(repositoryImage);
        if (LOG.isTraceEnabled()) {
            LOG.trace("New images size=" + imagesList.size());
        }
        this.imageGalleryService.saveImageOrder(imageGallery);
    }
}

