/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.service.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.genesys2.server.filerepository.BytesStorageException;
import org.genesys2.server.filerepository.service.BytesStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileSystemStorage")
public class FilesystemStorageServiceImpl
implements BytesStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemStorageServiceImpl.class);
    private File repoDir;

    public void setRepositoryBaseDirectory(File repoDir) {
        this.repoDir = repoDir;
    }

    public void afterPropertiesSet() throws BytesStorageException {
        this.sanityCheck();
    }

    protected void sanityCheck() throws BytesStorageException {
        if (!this.repoDir.isDirectory()) {
            throw new BytesStorageException("Base path is not a directory");
        }
        File repositoryMarker = new File(this.repoDir, "FILEREPOSITORY");
        if (!repositoryMarker.exists() || !repositoryMarker.isFile()) {
            throw new BytesStorageException("Missing FILEREPOSITORY marker in " + this.repoDir.getAbsolutePath());
        }
    }

    @Override
    public void upsert(String path, String filename, byte[] data) throws FileNotFoundException, IOException {
        File destinationDir = new File(this.repoDir, path);
        if (!destinationDir.getCanonicalPath().startsWith(this.repoDir.getCanonicalPath())) {
            throw new IOException("Not within repository path: " + destinationDir.getAbsolutePath());
        }
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        } else if (!destinationDir.isDirectory()) {
            throw new IOException("Exists, not a directory: " + destinationDir.getAbsolutePath());
        }
        File destinationFile = new File(destinationDir, filename);
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFile, false));){
            IOUtils.write((byte[])data, (OutputStream)output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void remove(String path, String filename) throws IOException {
        File destinationDir = new File(this.repoDir, path);
        File destinationFile = new File(destinationDir, filename);
        if (!destinationDir.getCanonicalPath().startsWith(this.repoDir.getCanonicalPath())) {
            throw new IOException("Not within repository path: " + destinationDir.getAbsolutePath());
        }
        if (destinationFile.exists()) {
            destinationFile.delete();
        }
        if (destinationDir.list().length == 0) {
            destinationDir.delete();
        }
    }

    @Override
    public byte[] get(String path, String filename) throws IOException {
        File destinationDir = new File(this.repoDir, path);
        File destinationFile = new File(destinationDir, filename);
        if (!destinationDir.getCanonicalPath().startsWith(this.repoDir.getCanonicalPath())) {
            throw new IOException("Not within repository path: " + destinationDir.getAbsolutePath());
        }
        byte[] data = null;
        if (destinationFile.exists()) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileInputStream inputStream = new FileInputStream(destinationFile);){
                data = IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return data;
    }

    @Override
    public boolean exists(String path, String filename) {
        File destinationDir = new File(this.repoDir, path);
        File destinationFile = new File(destinationDir, filename);
        return destinationFile.exists();
    }

    @Override
    public List<String> listFiles(String path) {
        File[] files;
        File destinationDir;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing filenames at path=" + path);
        }
        if ((destinationDir = new File(this.repoDir, path)).exists() && destinationDir.isDirectory()) {
            LOG.info("Returning empty files list for nonexistent dir=" + destinationDir.getAbsolutePath());
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing filenames in dir=" + destinationDir.getAbsolutePath());
        }
        if ((files = destinationDir.listFiles()) == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> !file.isDirectory()).map(file -> file.getName()).collect(Collectors.toList());
    }
}

