/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.genesys2.server.filerepository.model.ImageGallery;
import org.genesys2.server.filerepository.model.RepositoryImage;
import org.genesys2.server.filerepository.persistence.ImageGalleryPersistence;
import org.genesys2.server.filerepository.service.BytesStorageService;
import org.genesys2.server.filerepository.service.ImageGalleryService;
import org.genesys2.server.filerepository.service.RepositoryService;
import org.genesys2.server.filerepository.service.ThumbnailGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class ImageGalleryServiceImpl
implements ImageGalleryService {
    private static final Logger LOG = LoggerFactory.getLogger(ImageGalleryServiceImpl.class);
    @Autowired
    private ImageGalleryPersistence imageGalleryPersistence;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BytesStorageService bytesStorageService;
    @Autowired
    private ThumbnailGenerator thumbnailGenerator;

    @Override
    public ImageGallery loadImageGallery(String path) {
        ImageGallery imageGallery = this.imageGalleryPersistence.findByPath(path);
        return this.deepLoad(imageGallery);
    }

    private ImageGallery deepLoad(ImageGallery imageGallery) {
        if (imageGallery != null) {
            imageGallery.getImages().size();
        }
        return imageGallery;
    }

    @Override
    @Transactional
    public ImageGallery createImageGallery(String path, String title, String description) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating ImageGallery at path=" + path);
        }
        ImageGallery imageGallery = new ImageGallery();
        imageGallery.setPath(path);
        imageGallery.setTitle(title);
        imageGallery.setDescription(description);
        ArrayList<RepositoryImage> images = new ArrayList<RepositoryImage>(this.repositoryService.listImages(imageGallery.getPath()));
        imageGallery.setImages(images);
        return (ImageGallery)this.imageGalleryPersistence.save(imageGallery);
    }

    @Override
    @Transactional
    public void removeGallery(ImageGallery imageGallery) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting ImageGallery with id=" + imageGallery.getId());
        }
        String thumbPath = String.valueOf(imageGallery.getPath()) + "_thumb/";
        this.bytesStorageService.listFiles(thumbPath).forEach(filename -> {
            try {
                LOG.debug("Removing _thumb path={} filename={}", (Object)thumbPath, filename);
                this.bytesStorageService.remove(thumbPath, (String)filename);
            }
            catch (Exception e) {
                LOG.error("Failed to remove bytes path=" + thumbPath + " filename=" + filename, (Throwable)e);
            }
        });
        this.imageGalleryPersistence.delete(imageGallery);
    }

    @Override
    @Transactional
    public ImageGallery updateImageGalery(ImageGallery imageGallery, String title, String description) {
        ImageGallery imageGallery2 = (ImageGallery)this.imageGalleryPersistence.findOne(imageGallery.getId());
        imageGallery2.setTitle(title);
        imageGallery2.setDescription(description);
        this.imageGalleryPersistence.save(imageGallery2);
        return this.deepLoad(imageGallery2);
    }

    @Override
    @Transactional
    public ImageGallery saveImageOrder(ImageGallery imageGallery) {
        ImageGallery imageGallery2 = (ImageGallery)this.imageGalleryPersistence.findOne(imageGallery.getId());
        imageGallery2.setImages(imageGallery.getImages());
        this.imageGalleryPersistence.save(imageGallery2);
        return this.deepLoad(imageGallery2);
    }

    @Override
    @Transactional
    public void ensureThumbnails(ImageGallery imageGallery, Integer width, Integer height) {
        ImageGallery imageGallery2 = (ImageGallery)this.imageGalleryPersistence.findOne(imageGallery.getId());
        if (CollectionUtils.isEmpty(imageGallery2.getImages())) {
            LOG.debug("ImageGallery has no images, skipping thumbnail generation for path=" + imageGallery2.getPath());
            return;
        }
        String thumbPath = String.valueOf(imageGallery2.getPath()) + "_thumb/";
        imageGallery2.getImages().forEach(repositoryImage -> {
            try {
                this.ensureThumbnail(thumbPath, width, height, (RepositoryImage)repositoryImage);
            }
            catch (Exception e) {
                LOG.error("Error generating thumbnail for " + repositoryImage, (Throwable)e);
            }
        });
    }

    private void ensureThumbnail(String thumbPath, Integer width, Integer height, RepositoryImage repositoryImage) throws IOException {
        String filename = ImageGalleryServiceImpl.getThumbnailFilename(width, height, repositoryImage.getUuid());
        if (!this.bytesStorageService.exists(thumbPath, filename)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generating new thumbnail width={} height={} for image={}", new Object[]{width, height, repositoryImage.getUuid()});
            }
            byte[] bytesPng = this.thumbnailGenerator.createThumbnail(width, height, this.bytesStorageService.get(repositoryImage.getPath(), repositoryImage.getFilename()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Persisting new thumbnail width={} height={} for image={}", new Object[]{width, height, repositoryImage.getUuid()});
            }
            this.bytesStorageService.upsert(thumbPath, filename, bytesPng);
        }
    }

    public static final String getThumbnailFilename(Integer width, Integer height, UUID uuid) {
        StringBuffer sb = new StringBuffer();
        if (width != null) {
            sb.append(width);
        }
        sb.append("x");
        if (height != null) {
            sb.append(height);
        }
        sb.append("_").append(uuid).append(".png");
        return sb.toString();
    }
}

