/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.service.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.genesys2.server.filerepository.InvalidRepositoryFileDataException;
import org.genesys2.server.filerepository.InvalidRepositoryPathException;
import org.genesys2.server.filerepository.NoSuchRepositoryFileException;
import org.genesys2.server.filerepository.model.RepositoryFile;
import org.genesys2.server.filerepository.model.RepositoryImage;
import org.genesys2.server.filerepository.persistence.RepositoryFilePersistence;
import org.genesys2.server.filerepository.persistence.RepositoryImagePersistence;
import org.genesys2.server.filerepository.service.BytesStorageService;
import org.genesys2.server.filerepository.service.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class RepositoryServiceImpl
implements RepositoryService {
    @Autowired
    private RepositoryFilePersistence repositoryFilePersistence;
    @Autowired
    private RepositoryImagePersistence repositoryImagePersistence;
    @Autowired
    private BytesStorageService bytesStorageService;

    @Override
    @Transactional
    public RepositoryFile addFile(String repositoryPath, String originalFilename, String mimeType, byte[] bytes, RepositoryFile metaData) throws InvalidRepositoryPathException, InvalidRepositoryFileDataException {
        if (!this.isValidPath(repositoryPath)) {
            throw new InvalidRepositoryPathException();
        }
        if (originalFilename == null || mimeType == null || bytes == null) {
            throw new InvalidRepositoryFileDataException();
        }
        RepositoryFile file = new RepositoryFile();
        if (metaData != null) {
            this.copyMetaData(metaData, file);
        }
        file.setOriginalFilename(originalFilename);
        file.setMimeType(mimeType);
        file.setPath(repositoryPath);
        file = (RepositoryFile)this.repositoryFilePersistence.save(file);
        try {
            this.bytesStorageService.upsert(file.getPath(), file.getFilename(), bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    @Override
    @Transactional
    public RepositoryImage addImage(String repositoryPath, String originalFilename, String mimeType, byte[] bytes, RepositoryImage metaData) throws InvalidRepositoryPathException, InvalidRepositoryFileDataException {
        if (!this.isValidPath(repositoryPath)) {
            throw new InvalidRepositoryPathException();
        }
        if (originalFilename == null || mimeType == null || bytes == null) {
            throw new InvalidRepositoryFileDataException();
        }
        RepositoryImage image = new RepositoryImage();
        if (metaData != null) {
            this.copyMetaData(metaData, image);
        }
        image.setPath(repositoryPath);
        image.setOriginalFilename(originalFilename);
        image.setMimeType(mimeType);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            BufferedImage imageData = ImageIO.read(in);
            if (imageData != null) {
                image.setWidth(imageData.getWidth());
                image.setHeight(imageData.getHeight());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        image = (RepositoryImage)this.repositoryImagePersistence.save(image);
        try {
            this.bytesStorageService.upsert(image.getPath(), image.getFilename(), bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    @Override
    public RepositoryFile getFile(UUID fileUuid) throws NoSuchRepositoryFileException {
        RepositoryFile file = this.repositoryFilePersistence.findByUuid(fileUuid);
        if (file != null) {
            return file;
        }
        file = this.repositoryImagePersistence.findByUuid(fileUuid);
        if (file == null) {
            throw new NoSuchRepositoryFileException();
        }
        return file;
    }

    @Override
    public byte[] getFileBytes(String repositoryPath, String filename) throws NoSuchRepositoryFileException {
        byte[] data = null;
        try {
            data = this.bytesStorageService.get(repositoryPath, filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public List<RepositoryFile> getFiles(String repositoryPath) {
        ArrayList<RepositoryFile> repositoryFiles = new ArrayList<RepositoryFile>();
        repositoryFiles.addAll(this.repositoryFilePersistence.findByPath(repositoryPath));
        return repositoryFiles;
    }

    @Override
    @Transactional
    public RepositoryFile updateFile(RepositoryFile fileData) throws NoSuchRepositoryFileException {
        if (fileData == null) {
            throw new NoSuchRepositoryFileException();
        }
        RepositoryFile repositoryFile = fileData.getMimeType().startsWith("image") ? (RepositoryFile)this.repositoryImagePersistence.save((RepositoryImage)fileData) : (RepositoryFile)this.repositoryFilePersistence.save(fileData);
        return repositoryFile;
    }

    @Override
    @Transactional
    public RepositoryFile updateBytes(RepositoryFile fileData, String mimeType, byte[] data) throws NoSuchRepositoryFileException, IOException {
        if (fileData == null) {
            throw new NoSuchRepositoryFileException();
        }
        fileData.setMimeType(mimeType);
        this.bytesStorageService.upsert(fileData.getPath(), fileData.getFilename(), data);
        return (RepositoryFile)this.repositoryFilePersistence.save(fileData);
    }

    @Override
    @Transactional
    public RepositoryImage updateBytes(RepositoryImage imageData, String mimeType, byte[] data) throws NoSuchRepositoryFileException, IOException {
        if (imageData == null) {
            throw new NoSuchRepositoryFileException();
        }
        imageData.setMimeType(mimeType);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(in);
        if (image != null) {
            imageData.setWidth(image.getWidth());
            imageData.setHeight(image.getHeight());
        }
        this.bytesStorageService.upsert(imageData.getPath(), imageData.getFilename(), data);
        return (RepositoryImage)this.repositoryImagePersistence.save(imageData);
    }

    @Override
    @Transactional
    public RepositoryFile removeFile(RepositoryFile repositoryFile) throws NoSuchRepositoryFileException, IOException {
        if (repositoryFile == null) {
            throw new NoSuchRepositoryFileException();
        }
        this.bytesStorageService.remove(repositoryFile.getPath(), repositoryFile.getFilename());
        if (repositoryFile.getMimeType().startsWith("image")) {
            this.repositoryImagePersistence.delete((RepositoryImage)repositoryFile);
        } else {
            this.repositoryFilePersistence.delete(repositoryFile);
        }
        return repositoryFile;
    }

    @Override
    @Transactional
    public RepositoryFile moveFile(RepositoryFile repositoryFile, String newPath) throws NoSuchRepositoryFileException, InvalidRepositoryPathException {
        if (!this.isValidPath(newPath)) {
            throw new InvalidRepositoryPathException();
        }
        if (repositoryFile == null) {
            throw new NoSuchRepositoryFileException();
        }
        repositoryFile.setPath(newPath);
        RepositoryFile file = repositoryFile.getMimeType().startsWith("image") ? (RepositoryFile)this.repositoryImagePersistence.save((RepositoryImage)repositoryFile) : (RepositoryFile)this.repositoryFilePersistence.save(repositoryFile);
        return file;
    }

    private void copyMetaData(RepositoryFile sourceFile, RepositoryFile resultFile) {
        resultFile.setMimeType(sourceFile.getMimeType());
        resultFile.setDescription(sourceFile.getDescription());
        resultFile.setOriginalFilename(sourceFile.getOriginalFilename());
        resultFile.setAccessRights(sourceFile.getAccessRights());
        resultFile.setBibliographicCitation(sourceFile.getBibliographicCitation());
        resultFile.setCreated(sourceFile.getCreated());
        resultFile.setCreatedDate(sourceFile.getCreatedDate());
        resultFile.setCreator(sourceFile.getCreator());
        resultFile.setExtent(sourceFile.getExtent());
        resultFile.setLastModifiedDate(sourceFile.getLastModifiedDate());
        resultFile.setLicense(sourceFile.getLicense());
        resultFile.setPath(sourceFile.getPath());
        resultFile.setRightsHolder(sourceFile.getRightsHolder());
        resultFile.setSubject(sourceFile.getSubject());
        resultFile.setTitle(sourceFile.getTitle());
    }

    private boolean isValidPath(String path) {
        return path != null && !StringUtils.containsWhitespace((String)path) && path.startsWith("/") && path.endsWith("/") && !path.contains("//");
    }

    @Override
    public List<RepositoryImage> listImages(String repositoryPath) {
        return this.repositoryImagePersistence.findByPath(repositoryPath);
    }
}

