/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.service.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.genesys2.server.filerepository.service.BytesStorageService;
import org.genesys2.server.filerepository.service.s3.ListBucketResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service(value="S3Storage")
public class S3StorageServiceImpl
implements BytesStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(S3StorageServiceImpl.class);
    private static final SimpleDateFormat HEADER_DATE_FORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    private final RestTemplate restTemplate = this.initializeRestTemplate();
    @Value(value="${s3.accessKey}")
    private String accessKey;
    @Value(value="${s3.secretKey}")
    private String secretKey;
    @Value(value="${s3.bucket}")
    private String bucket;
    @Value(value="${s3.region}")
    private String region;
    @Value(value="${s3.prefix}")
    private String prefix;

    @Override
    public void upsert(String path, String filename, byte[] data) throws FileNotFoundException, IOException {
        if (!this.isValidPath(path)) {
            throw new IOException("Path is not valid");
        }
        if (filename == null) {
            throw new IOException("File name is null");
        }
        if (data == null) {
            throw new IOException("File bytes are null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Putting to path={} filename={} len={}", new Object[]{path, filename, data.length});
        }
        String url = this.getUrl(path, filename);
        this.restTemplate.put(url, (Object)data, new Object[0]);
    }

    @Override
    public void remove(String path, String filename) throws IOException {
        if (!this.isValidPath(path)) {
            throw new IOException("Path is not valid");
        }
        if (filename == null) {
            throw new IOException("File name is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting from path={} filename={}", (Object)path, (Object)filename);
        }
        String url = this.getUrl(path, filename);
        this.restTemplate.delete(url, new Object[0]);
    }

    @Override
    public byte[] get(String path, String filename) throws IOException {
        if (!this.isValidPath(path)) {
            throw new IOException("Path is not valid");
        }
        if (filename == null) {
            throw new IOException("File name is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting bytes path={} filename={}", (Object)path, (Object)filename);
        }
        String url = this.getUrl(path, filename);
        return (byte[])this.restTemplate.getForObject(url, byte[].class, new Object[0]);
    }

    private String getUrl(String path, String filename) {
        return String.format("https://%s%s", this.getHost(), String.valueOf(this.getPath(path)) + filename);
    }

    private String getPath(String path) {
        if (StringUtils.isEmpty((Object)this.prefix)) {
            return path;
        }
        return String.valueOf(this.prefix) + path;
    }

    private String getHost() {
        return String.format("%s.s3-%s.amazonaws.com", this.bucket, this.region);
    }

    private String getStringToSign(String method, String date, String filePath, MediaType mediaType) {
        StringBuilder sb = new StringBuilder(method).append("\n");
        sb.append("\n");
        if (mediaType != null) {
            sb.append(mediaType.toString());
        }
        sb.append("\n");
        sb.append(date).append("\n");
        sb.append("/").append(this.bucket).append(filePath);
        return sb.toString();
    }

    private String getAuthorizationHeader(String signature) {
        return "AWS" + " " + this.accessKey + ":" + signature;
    }

    private byte[] encryptHmacSHA1(String stringToSign) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        String algorithm = "HmacSHA1";
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(this.secretKey.getBytes("UTF8"), "HmacSHA1"));
        return mac.doFinal(stringToSign.getBytes("UTF8"));
    }

    private boolean isValidPath(String path) {
        return path != null && !StringUtils.containsWhitespace((String)path) && path.startsWith("/") && path.endsWith("/") && !path.contains("//");
    }

    private RestTemplate initializeRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>();
        interceptors.add((request, body, execution) -> {
            String date = HEADER_DATE_FORMAT.format(new Date());
            request.getHeaders().set("Date", date);
            request.getHeaders().set("Host", this.getHost());
            String stringToSign = this.getStringToSign(request.getMethod().toString(), date, request.getURI().getPath(), request.getHeaders().getContentType());
            String authorizationHeader = null;
            try {
                byte[] signatureBytes = this.encryptHmacSHA1(stringToSign);
                String signature = new String(Base64.getEncoder().encode(signatureBytes));
                authorizationHeader = this.getAuthorizationHeader(signature);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException("Signature for request can't be created");
            }
            request.getHeaders().set("Authorization", authorizationHeader);
            ClientHttpResponse response = execution.execute(request, body);
            return response;
        });
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }

    @Override
    public boolean exists(String path, String filename) {
        try {
            HttpHeaders headers = this.restTemplate.headForHeaders(this.getUrl(path, filename), new Object[0]);
            if (LOG.isDebugEnabled()) {
                headers.forEach((header, values) -> LOG.debug("{}: {}", header, values));
            }
            return true;
        }
        catch (Throwable e) {
            LOG.warn("Catch this thing!");
            throw e;
        }
    }

    @Override
    public List<String> listFiles(String path) {
        LOG.debug("Listing S3 bucket for host={} path={}", (Object)this.getHost(), (Object)path);
        String s3prefix = this.getPath(path).substring(1);
        ListBucketResult listBucketResult = (ListBucketResult)this.restTemplate.getForObject("https://" + this.getHost() + "/?delimiter=/&prefix={path}", ListBucketResult.class, new Object[]{s3prefix});
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bucket name={} maxKeys={} delimiter={} prefix={}", new Object[]{listBucketResult.getName(), listBucketResult.getMaxKeys(), listBucketResult.getDelimiter(), listBucketResult.getPrefix()});
            if (listBucketResult.getCommonPrefixes() != null) {
                listBucketResult.getCommonPrefixes().forEach(commonPrefix -> LOG.debug("Subprefix={}", (Object)commonPrefix.getPrefix()));
            }
            if (listBucketResult.getContents() != null) {
                listBucketResult.getContents().forEach(content -> LOG.debug("Object prefix={} len={} filename={}", new Object[]{content.getKey(), content.getSize(), content.getKey().substring(s3prefix.length())}));
            }
        }
        if (listBucketResult.getContents() == null) {
            return Collections.emptyList();
        }
        return listBucketResult.getContents().stream().map(content -> content.getKey().substring(s3prefix.length())).collect(Collectors.toList());
    }
}

